/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.batch.engine.internal.writer.ItemClassIndexUtil;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ColumnValuesExtractor {
    private static final Log _log = LogFactoryUtil.getLog(ColumnValuesExtractor.class);
    private final ColumnDescriptor[] _columnDescriptors;

    public ColumnValuesExtractor(Map<String, Field> fieldsMap, List<String> fieldNames) {
        this._columnDescriptors = this._getColumnDescriptors(fieldsMap, fieldNames, 0, null);
    }

    public List<Object[]> extractValues(Object item) throws ReflectiveOperationException {
        ArrayList<Object[]> valuesList = new ArrayList<Object[]>();
        Object[] values = this._getBlankValues(this._columnDescriptors.length);
        ArrayList<ColumnDescriptor> childFieldColumnDescriptors = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor columnDescriptor : this._columnDescriptors) {
            if (columnDescriptor._isChild()) {
                childFieldColumnDescriptors.add(columnDescriptor);
                continue;
            }
            values[((ColumnDescriptor)columnDescriptor)._index] = columnDescriptor._getValue(item);
        }
        valuesList.add(values);
        int hash = -1;
        for (ColumnDescriptor childFieldColumnDescriptor : childFieldColumnDescriptors) {
            if (hash != childFieldColumnDescriptor._getParentHashCode()) {
                hash = childFieldColumnDescriptor._getParentHashCode();
                values = this._getBlankValues(this._columnDescriptors.length);
                valuesList.add(values);
            }
            values[((ColumnDescriptor)childFieldColumnDescriptor)._index] = childFieldColumnDescriptor._getValue(item);
        }
        return valuesList;
    }

    public String[] getHeaders() {
        String[] headers = new String[this._columnDescriptors.length];
        for (ColumnDescriptor columnDescriptor : this._columnDescriptors) {
            headers[((ColumnDescriptor)columnDescriptor)._index] = columnDescriptor._getHeader();
        }
        return headers;
    }

    private <T> T[] _combine(T[] array1, T[] array2, int index) {
        Class<?> array1Class = array1.getClass();
        Object[] newArray = (Object[])Array.newInstance(array1Class.getComponentType(), array1.length + array2.length - 1);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, index, array2.length);
        return newArray;
    }

    private Object[] _getBlankValues(int size) {
        Object[] objects = new Object[size];
        Arrays.fill(objects, "");
        return objects;
    }

    private ColumnDescriptor[] _getColumnDescriptors(Map<String, Field> fieldsMap, Collection<String> fieldNames, int masterIndex, ColumnDescriptor parentColumnDescriptor) {
        ColumnDescriptor[] columnDescriptors = new ColumnDescriptor[fieldNames.size()];
        int localIndex = 0;
        for (String fieldName : fieldNames) {
            Field field = fieldsMap.get(fieldName);
            if (field == null) {
                columnDescriptors[localIndex] = ColumnDescriptor._from(null, fieldName, masterIndex++, parentColumnDescriptor, (UnsafeFunction<Object, Object, ReflectiveOperationException>)this._getUnsafeFunction(fieldsMap, fieldName));
                ++localIndex;
                continue;
            }
            columnDescriptors[localIndex] = ColumnDescriptor._from(field, field.getName(), masterIndex++, parentColumnDescriptor, (UnsafeFunction<Object, Object, ReflectiveOperationException>)this._getUnsafeFunction(fieldsMap, fieldName));
            Class<?> fieldClass = field.getType();
            if (ItemClassIndexUtil.isMap(fieldClass) || ItemClassIndexUtil.isSingleColumnAdoptableArray(fieldClass) || ItemClassIndexUtil.isSingleColumnAdoptableValue(fieldClass)) {
                ++localIndex;
                continue;
            }
            if (ItemClassIndexUtil.isIterable(fieldClass)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Mapping collection of ", fieldClass.getDeclaredClasses(), " to a single column may not contain all data"}));
                }
                ++localIndex;
                continue;
            }
            Map<String, Field> childFieldsMap = ItemClassIndexUtil.index(fieldClass);
            ColumnDescriptor[] childFieldColumnDescriptors = this._getColumnDescriptors(childFieldsMap, this._sort(childFieldsMap.keySet()), localIndex, columnDescriptors[localIndex]);
            columnDescriptors = this._combine(columnDescriptors, childFieldColumnDescriptors, localIndex);
            masterIndex = this._getLastMasterIndex(childFieldColumnDescriptors) + 1;
            localIndex += childFieldColumnDescriptors.length;
        }
        return columnDescriptors;
    }

    private int _getLastMasterIndex(ColumnDescriptor[] columnDescriptors) {
        ColumnDescriptor columnDescriptor = columnDescriptors[columnDescriptors.length - 1];
        return columnDescriptor._index;
    }

    private String _getListEntryKey(Object object) {
        ListEntry listEntry = (ListEntry)object;
        return listEntry.getKey();
    }

    private UnsafeFunction<Object, Object, ReflectiveOperationException> _getUnsafeFunction(Map<String, Field> fieldsMap, final String fieldName) {
        final Field field = fieldsMap.get(fieldName);
        if (field != null) {
            Class<?> fieldClass = field.getType();
            if (ItemClassIndexUtil.isSingleColumnAdoptableValue(fieldClass)) {
                return new UnsafeFunction<Object, Object, ReflectiveOperationException>(){

                    public Object apply(Object object) throws ReflectiveOperationException {
                        if (field.get(object) == null) {
                            return "";
                        }
                        return field.get(object);
                    }
                };
            }
            if (ItemClassIndexUtil.isSingleColumnAdoptableArray(fieldClass)) {
                return new UnsafeFunction<Object, Object, ReflectiveOperationException>(){

                    public Object apply(Object object) throws ReflectiveOperationException {
                        if (field.get(object) == null) {
                            return "";
                        }
                        return StringUtil.merge((Object[])((Object[])field.get(object)), CSVUtil::encode, (String)",");
                    }
                };
            }
            if (ItemClassIndexUtil.isMap(fieldClass)) {
                return new UnsafeFunction<Object, Object, ReflectiveOperationException>(){

                    public Object apply(Object object) throws ReflectiveOperationException {
                        Map map = (Map)field.get(object);
                        if (map == null) {
                            return "";
                        }
                        StringBundler sb = new StringBundler(map.size() * 3);
                        Set entries = map.entrySet();
                        Iterator iterator = entries.iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            sb.append(CSVUtil.encode(entry.getKey()));
                            sb.append(":");
                            if (entry.getValue() != null) {
                                sb.append(CSVUtil.encode(entry.getValue()));
                            } else {
                                sb.append("");
                            }
                            if (!iterator.hasNext()) continue;
                            sb.append(", ");
                        }
                        return sb.toString();
                    }
                };
            }
            return new UnsafeFunction<Object, Object, ReflectiveOperationException>(){

                public Object apply(Object object) throws ReflectiveOperationException {
                    if (field.get(object) == null) {
                        return "";
                    }
                    return CSVUtil.encode((Object)object);
                }
            };
        }
        final Field propertiesField = fieldsMap.get("properties");
        if (!ItemClassIndexUtil.isObjectEntryProperties(propertiesField)) {
            throw new IllegalArgumentException("Invalid field name: " + fieldName);
        }
        return new UnsafeFunction<Object, Object, ReflectiveOperationException>(){

            public Object apply(Object object) throws ReflectiveOperationException {
                Map map = (Map)propertiesField.get(object);
                Object value = map.get(fieldName);
                if (value == null) {
                    return "";
                }
                if (ItemClassIndexUtil.isListEntry(value)) {
                    return ColumnValuesExtractor.this._getListEntryKey(value);
                }
                if (value instanceof String) {
                    return CSVUtil.encode(value);
                }
                return value;
            }
        };
    }

    private Collection<String> _sort(Collection<String> collection) {
        return ListUtil.sort(new ArrayList<String>(collection), (value1, value2) -> value1.compareToIgnoreCase((String)value2));
    }

    private static class ColumnDescriptor {
        private final Field _field;
        private final String _fieldName;
        private final int _index;
        private final List<ColumnDescriptor> _parentColumnDescriptors = new ArrayList<ColumnDescriptor>();
        private final UnsafeFunction<Object, Object, ReflectiveOperationException> _unsafeFunction;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ColumnDescriptor)) {
                return false;
            }
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)object;
            return Objects.equals(this._field, columnDescriptor._field) && this._parentColumnDescriptors.equals(columnDescriptor._parentColumnDescriptors);
        }

        public int hashCode() {
            return this._field.hashCode();
        }

        private static ColumnDescriptor _from(Field field, String fieldName, int index, ColumnDescriptor parentColumnDescriptor, UnsafeFunction<Object, Object, ReflectiveOperationException> unsafeFunction) {
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(field, fieldName, index, unsafeFunction);
            if (parentColumnDescriptor == null) {
                return columnDescriptor;
            }
            columnDescriptor._add(parentColumnDescriptor);
            return columnDescriptor;
        }

        private ColumnDescriptor(Field field, String fieldName, int index, UnsafeFunction<Object, Object, ReflectiveOperationException> unsafeFunction) {
            this._field = field;
            this._fieldName = fieldName;
            this._index = index;
            this._unsafeFunction = unsafeFunction;
        }

        private void _add(ColumnDescriptor columnDescriptor) {
            if (!columnDescriptor._parentColumnDescriptors.isEmpty()) {
                this._parentColumnDescriptors.addAll(columnDescriptor._parentColumnDescriptors);
            }
            this._parentColumnDescriptors.add(columnDescriptor);
        }

        private String _getHeader() {
            StringBundler sb = new StringBundler(this._parentColumnDescriptors.size() * 2 + 2);
            for (ColumnDescriptor columnDescriptor : this._parentColumnDescriptors) {
                sb.append(columnDescriptor._getSanitizedFieldName());
                sb.append(".");
            }
            sb.append(this._getSanitizedFieldName());
            return sb.toString();
        }

        private int _getParentHashCode() {
            if (this._parentColumnDescriptors.isEmpty()) {
                throw new UnsupportedOperationException();
            }
            ColumnDescriptor columnDescriptor = this._parentColumnDescriptors.get(this._parentColumnDescriptors.size() - 1);
            return columnDescriptor.hashCode();
        }

        private String _getSanitizedFieldName() {
            if (this._fieldName.startsWith("_")) {
                return this._fieldName.substring(1);
            }
            return this._fieldName;
        }

        private Object _getValue(Object object) throws ReflectiveOperationException {
            if (!this._isChild()) {
                return this._unsafeFunction.apply(object);
            }
            Object result = object;
            for (ColumnDescriptor columnDescriptor : this._parentColumnDescriptors) {
                if ((result = columnDescriptor._field.get(result)) != null) continue;
                return "";
            }
            return this._unsafeFunction.apply(result);
        }

        private boolean _isChild() {
            return !this._parentColumnDescriptors.isEmpty();
        }
    }
}

