/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.unit;

import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.batch.engine.unit.BatchEngineUnitProcessor;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BatchEngineUnitProcessor.class})
public class BatchEngineUnitProcessorImpl
implements BatchEngineUnitProcessor {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineUnitProcessorImpl.class);
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private File _file;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    @Reference
    private UserLocalService _userLocalService;

    public void processBatchEngineUnits(Iterable<BatchEngineUnit> batchEngineUnits) {
        for (BatchEngineUnit batchEngineUnit : batchEngineUnits) {
            try {
                this._processBatchEngineUnit(batchEngineUnit);
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)StringBundler.concat((String[])new String[]{"Successfully enqueued batch file ", batchEngineUnit.getFileName(), " ", batchEngineUnit.getDataFileName()}));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)exception);
            }
        }
    }

    private void _processBatchEngineUnit(BatchEngineUnit batchEngineUnit) throws Exception {
        BatchEngineUnitConfiguration batchEngineUnitConfiguration = null;
        byte[] content = null;
        String contentType = null;
        if (batchEngineUnit.isValid()) {
            batchEngineUnitConfiguration = this._updateBatchEngineUnitConfiguration(batchEngineUnit.getBatchEngineUnitConfiguration());
            UnsyncByteArrayOutputStream compressedUnsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            try (InputStream inputStream = batchEngineUnit.getDataInputStream();
                 ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)compressedUnsyncByteArrayOutputStream);){
                zipOutputStream.putNextEntry(new ZipEntry(batchEngineUnit.getDataFileName()));
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
            }
            content = compressedUnsyncByteArrayOutputStream.toByteArray();
            contentType = this._file.getExtension(batchEngineUnit.getDataFileName());
        }
        if (batchEngineUnitConfiguration == null || content == null || Validator.isNull(contentType)) {
            throw new IllegalStateException(StringBundler.concat((String[])new String[]{"Invalid batch engine file ", batchEngineUnit.getFileName(), " ", batchEngineUnit.getDataFileName()}));
        }
        Map parameters = batchEngineUnitConfiguration.getParameters();
        String featureFlag = (String)parameters.get("featureFlag");
        if (Validator.isNotNull((String)featureFlag) && !FeatureFlagManagerUtil.isEnabled((String)featureFlag)) {
            return;
        }
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(BatchEngineUnitProcessorImpl.class.getName());
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskLocalService.addBatchEngineImportTask(null, batchEngineUnitConfiguration.getCompanyId(), batchEngineUnitConfiguration.getUserId(), 100L, batchEngineUnitConfiguration.getCallbackURL(), batchEngineUnitConfiguration.getClassName(), content, StringUtil.toUpperCase(contentType), BatchEngineTaskExecuteStatus.INITIAL.name(), batchEngineUnitConfiguration.getFieldNameMappingMap(), 2, BatchEngineTaskOperation.CREATE.name(), batchEngineUnitConfiguration.getParameters(), batchEngineUnitConfiguration.getTaskItemDelegateName());
        executorService.submit(() -> {
            this._batchEngineImportTaskExecutor.execute(batchEngineImportTask);
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Successfully deployed batch engine file ", batchEngineUnit.getFileName(), " ", batchEngineUnit.getDataFileName()}));
            }
        });
    }

    private BatchEngineUnitConfiguration _updateBatchEngineUnitConfiguration(BatchEngineUnitConfiguration batchEngineUnitConfiguration) {
        if (batchEngineUnitConfiguration.getCompanyId() == 0L) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Using default company ID for this batch process");
            }
            try {
                Company company = this._companyLocalService.getCompanyByWebId(PropsUtil.get((String)"company.default.web.id"));
                batchEngineUnitConfiguration.setCompanyId(company.getCompanyId());
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to get default company ID", (Throwable)portalException);
            }
        }
        if (batchEngineUnitConfiguration.getUserId() == 0L) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Using default user ID for this batch process");
            }
            try {
                batchEngineUnitConfiguration.setUserId(this._userLocalService.getUserIdByScreenName(batchEngineUnitConfiguration.getCompanyId(), PropsUtil.get((String)"default.admin.screen.name")));
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to get default user ID", (Throwable)portalException);
            }
        }
        return batchEngineUnitConfiguration;
    }
}

