/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.scheduler;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration"}, service={SchedulerJobConfiguration.class})
public class BatchEngineTaskCleanerSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    private BatchEngineTaskConfiguration _batchEngineTaskConfiguration;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            for (BatchEngineExportTask batchEngineExportTask : this._batchEngineExportTaskLocalService.getBatchEngineExportTasks(BatchEngineTaskExecuteStatus.COMPLETED.toString())) {
                this._batchEngineExportTaskLocalService.deleteBatchEngineExportTask(batchEngineExportTask.getBatchEngineExportTaskId());
            }
            for (BatchEngineImportTask batchEngineImportTask : this._batchEngineImportTaskLocalService.getBatchEngineImportTasks(BatchEngineTaskExecuteStatus.COMPLETED.toString())) {
                this._batchEngineImportTaskLocalService.deleteBatchEngineImportTask(batchEngineImportTask.getBatchEngineImportTaskId());
            }
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)this._batchEngineTaskConfiguration.completedTasksCleanerScanInterval(), (TimeUnit)TimeUnit.DAY);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._batchEngineTaskConfiguration = (BatchEngineTaskConfiguration)ConfigurableUtil.createConfigurable(BatchEngineTaskConfiguration.class, properties);
    }
}

