/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.installer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.internal.installer.AdvancedBatchEngineZipUnitImpl;
import com.liferay.batch.engine.internal.installer.BatchEngineZipUnit;
import com.liferay.batch.engine.internal.installer.ClassicBatchEngineZipUnitImpl;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FileInstaller.class})
public class BatchEngineFileInstaller
implements FileInstaller {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineFileInstaller.class);
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private File _file;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canTransformURL(java.io.File file) {
        String fileName = file.getName();
        if (!StringUtil.endsWith((String)fileName, (String)".zip")) return false;
        if (this._isClientExtension(file)) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            BatchEngineImportConfiguration batchEngineImportConfiguration;
            BatchEngineZipUnit batchEngineZipUnit;
            if (this._isProcessed(zipFile)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Batch engine file " + zipFile.getName() + "was already processed"));
                }
                boolean bl = false;
                return bl;
            }
            Iterator<BatchEngineZipUnit> iterator = this._getBatchEngineZipUnits(zipFile).iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(batchEngineZipUnit = iterator.next()).isValid() || (batchEngineImportConfiguration = this._getBatchEngineImportConfiguration(batchEngineZipUnit)) == null || batchEngineImportConfiguration.companyId <= 0L || batchEngineImportConfiguration.userId <= 0L || !Validator.isNotNull((String)batchEngineImportConfiguration.className) || !Validator.isNotNull((String)batchEngineImportConfiguration.version));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return false;
            _log.debug((Throwable)new AutoDeployException((Throwable)exception));
        }
        return false;
    }

    public boolean isBatchEngineTechnical(String zipEntryName) {
        return zipEntryName.endsWith("batch-engine-data.json");
    }

    public URL transformURL(java.io.File file) throws AutoDeployException {
        try (ZipFile zipFile = new ZipFile(file);){
            this._deploy(zipFile);
            this._setProcessed(zipFile);
        }
        catch (Exception exception) {
            throw new AutoDeployException((Throwable)exception);
        }
        return null;
    }

    public void uninstall(java.io.File file) {
    }

    private void _deploy(ZipFile zipFile) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deploying batch engine file " + zipFile.getName()));
        }
        for (BatchEngineZipUnit batchEngineZipUnit : this._getBatchEngineZipUnits(zipFile)) {
            try {
                this._processBatchEngineZipUnit(batchEngineZipUnit);
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Successfully enqueued batch file " + batchEngineZipUnit));
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Ignoring invalid batch file " + batchEngineZipUnit), (Throwable)exception);
            }
        }
    }

    private BatchEngineImportConfiguration _getBatchEngineImportConfiguration(BatchEngineZipUnit<BatchEngineImportConfiguration> batchEngineZipUnit) throws IOException {
        BatchEngineImportConfiguration batchEngineConfiguration = batchEngineZipUnit.getBatchEngineConfiguration(BatchEngineImportConfiguration.class);
        if (batchEngineConfiguration.companyId == 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Using default company ID for this batch process");
            }
            try {
                Company company = this._companyLocalService.getCompanyByWebId(PropsUtil.get((String)"company.default.web.id"));
                batchEngineConfiguration.companyId = company.getCompanyId();
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to get default company ID", (Throwable)portalException);
            }
        }
        if (batchEngineConfiguration.userId == 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Using default user ID for this batch process");
            }
            try {
                batchEngineConfiguration.userId = this._userLocalService.getUserIdByScreenName(batchEngineConfiguration.companyId, PropsUtil.get((String)"default.admin.screen.name"));
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to get default user ID", (Throwable)portalException);
            }
        }
        return batchEngineConfiguration;
    }

    private String _getBatchEngineZipEntryKey(ZipEntry zipEntry) {
        String zipEntryName = zipEntry.getName();
        if (this.isBatchEngineTechnical(zipEntryName)) {
            return zipEntryName;
        }
        if (!zipEntryName.contains("/")) {
            return "";
        }
        return zipEntryName.substring(0, zipEntryName.lastIndexOf("/"));
    }

    private Iterable<BatchEngineZipUnit> _getBatchEngineZipUnits(final ZipFile zipFile) {
        return new Iterable<BatchEngineZipUnit>(){

            @Override
            public Iterator<BatchEngineZipUnit> iterator() {
                return new BatchEngineZipUnitIterator(zipFile);
            }
        };
    }

    private Collection<BatchEngineZipUnit> _getBatchEngineZipUnitsCollection(ZipFile zipFile) {
        HashMap<String, ZipEntry> batchEngineZipEntries = new HashMap<String, ZipEntry>();
        HashMap batchEngineZipUnits = new HashMap();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            String key = this._getBatchEngineZipEntryKey(zipEntry);
            ZipEntry complementZipEntry = (ZipEntry)batchEngineZipEntries.get(key);
            if (complementZipEntry == null) {
                batchEngineZipEntries.put(key, zipEntry);
                batchEngineZipUnits.put(key, new AdvancedBatchEngineZipUnitImpl(zipFile, zipEntry));
                continue;
            }
            batchEngineZipUnits.put(key, new ClassicBatchEngineZipUnitImpl(zipFile, zipEntry, complementZipEntry));
            batchEngineZipEntries.remove(key);
        }
        return batchEngineZipUnits.values();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _isClientExtension(java.io.File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!Objects.equals(name, "WEB-INF/liferay-plugin-package.properties") && (!name.endsWith(".client-extension-config.json") || name.indexOf("/") != -1)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to check if " + file + " is a client extension"), (Throwable)ioException);
            return false;
        }
    }

    private boolean _isProcessed(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!Objects.equals(zipEntry.getName(), ".processed-batch-engine-zip")) continue;
            return true;
        }
        return false;
    }

    private void _processBatchEngineZipUnit(BatchEngineZipUnit<BatchEngineImportConfiguration> batchEngineZipUnit) throws Exception {
        BatchEngineImportConfiguration batchEngineImportConfiguration = null;
        byte[] content = null;
        String contentType = null;
        if (batchEngineZipUnit.isValid()) {
            batchEngineImportConfiguration = this._getBatchEngineImportConfiguration(batchEngineZipUnit);
            UnsyncByteArrayOutputStream compressedUnsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            try (InputStream inputStream = batchEngineZipUnit.getDataInputStream();
                 ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)compressedUnsyncByteArrayOutputStream);){
                zipOutputStream.putNextEntry(new ZipEntry(batchEngineZipUnit.getDataFileName()));
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
            }
            content = compressedUnsyncByteArrayOutputStream.toByteArray();
            contentType = this._file.getExtension(batchEngineZipUnit.getDataFileName());
        }
        if (batchEngineImportConfiguration == null || content == null || Validator.isNull(contentType)) {
            throw new IllegalStateException("Invalid batch engine file " + batchEngineZipUnit.getZipFileName());
        }
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(BatchEngineFileInstaller.class.getName());
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskLocalService.addBatchEngineImportTask(null, batchEngineImportConfiguration.companyId, batchEngineImportConfiguration.userId, 100L, batchEngineImportConfiguration.callbackURL, batchEngineImportConfiguration.className, content, StringUtil.toUpperCase(contentType), BatchEngineTaskExecuteStatus.INITIAL.name(), batchEngineImportConfiguration.fieldNameMappingMap, 2, BatchEngineTaskOperation.CREATE.name(), batchEngineImportConfiguration.parameters, batchEngineImportConfiguration.taskItemDelegateName);
        executorService.submit(() -> {
            this._batchEngineImportTaskExecutor.execute(batchEngineImportTask);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Successfully deployed batch engine file " + batchEngineZipUnit.getZipFileName()));
            }
        });
    }

    private void _setProcessed(ZipFile zipFile) throws Exception {
        Path zipFilePath = Paths.get(zipFile.getName(), new String[0]);
        try (FileSystem fileSystem = FileSystems.newFileSystem(zipFilePath, null);){
            Files.write(fileSystem.getPath(".processed-batch-engine-zip", new String[0]), new byte[0], StandardOpenOption.CREATE);
        }
    }

    private class BatchEngineZipUnitIterator
    implements Iterator<BatchEngineZipUnit> {
        private final Iterator<BatchEngineZipUnit> _iterator;

        public BatchEngineZipUnitIterator(ZipFile zipFile) {
            Collection batchEngineZipUnits = BatchEngineFileInstaller.this._getBatchEngineZipUnitsCollection(zipFile);
            this._iterator = batchEngineZipUnits.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public BatchEngineZipUnit next() {
            return this._iterator.next();
        }
    }

    public static final class BatchEngineImportConfiguration {
        @JsonProperty
        protected String callbackURL;
        @JsonProperty
        protected String className;
        @JsonProperty
        protected long companyId;
        @JsonProperty
        protected Map<String, String> fieldNameMappingMap;
        @JsonProperty
        protected Map<String, Serializable> parameters;
        @JsonProperty
        protected String taskItemDelegateName;
        @JsonProperty
        protected long userId;
        @JsonProperty
        protected String version;

        public String getCallbackURL() {
            return this.callbackURL;
        }

        public String getClassName() {
            return this.className;
        }

        public long getCompanyId() {
            return this.companyId;
        }

        public Map<String, String> getFieldNameMappingMap() {
            return this.fieldNameMappingMap;
        }

        public Map<String, Serializable> getParameters() {
            return this.parameters;
        }

        public String getTaskItemDelegateName() {
            return this.taskItemDelegateName;
        }

        public long getUserId() {
            return this.userId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setFieldNameMappingMap(Map<String, String> fieldNameMappingMap) {
            if (fieldNameMappingMap == null) {
                fieldNameMappingMap = Collections.emptyMap();
            }
            this.fieldNameMappingMap = new HashMap<String, String>(fieldNameMappingMap);
        }

        public void setParameters(Map<String, Serializable> parameters) {
            if (parameters == null) {
                parameters = Collections.emptyMap();
            }
            this.parameters = new HashMap<String, Serializable>(parameters);
        }

        public void setTaskItemDelegateName(String taskItemDelegateName) {
            this.taskItemDelegateName = taskItemDelegateName;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

