/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.installer;

import com.liferay.batch.engine.internal.installer.BatchEngineZipUnit;
import com.liferay.batch.engine.internal.json.AdvancedJSONReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AdvancedBatchEngineZipUnitImpl<T>
implements BatchEngineZipUnit<T> {
    private static final Log _log = LogFactoryUtil.getLog(AdvancedBatchEngineZipUnitImpl.class);
    private ZipEntry _zipEntry;
    private final ZipFile _zipFile;

    public AdvancedBatchEngineZipUnitImpl(ZipFile zipFile, ZipEntry zipEntry) {
        this._zipFile = zipFile;
        this._zipEntry = zipEntry;
    }

    @Override
    public T getBatchEngineConfiguration(Class<T> clazz) throws IOException {
        try (InputStream inputStream = this._zipFile.getInputStream(this._zipEntry);){
            AdvancedJSONReader<T> advancedJSONReader = new AdvancedJSONReader<T>(inputStream);
            Object t = advancedJSONReader.getObject("configuration", clazz);
            return t;
        }
    }

    @Override
    public InputStream getConfigurationInputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDataFileName() {
        return this._zipEntry.getName();
    }

    @Override
    public InputStream getDataInputStream() throws IOException {
        try (InputStream inputStream = this._zipFile.getInputStream(this._zipEntry);){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(inputStream);
            advancedJSONReader.transferJSONArray("items", byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    @Override
    public String getZipFileName() {
        return this._zipFile.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid() {
        if (this._zipEntry == null) {
            return false;
        }
        try (InputStream inputStream = this._zipFile.getInputStream(this._zipEntry);){
            AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(inputStream);
            boolean bl = advancedJSONReader.hasKey("items");
            return bl;
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to get data in file " + this._zipEntry.getName()), (Throwable)ioException);
            return false;
        }
    }
}

