/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.bundle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import org.osgi.framework.Bundle;

public class ClassicBatchEngineBundleUnitImpl
implements BatchEngineUnit {
    private final Bundle _bundle;
    private URL _configurationURL;
    private URL _dataURL;

    public ClassicBatchEngineBundleUnitImpl(Bundle bundle, URL ... urls) {
        this._bundle = bundle;
        if (urls == null || urls.length > 2) {
            return;
        }
        for (URL url : urls) {
            if (this._isBatchEngineConfiguration(url.getPath())) {
                this._configurationURL = url;
                continue;
            }
            this._dataURL = url;
        }
    }

    public BatchEngineUnitConfiguration getBatchEngineUnitConfiguration() throws IOException {
        try (InputStream inputStream = this._configurationURL.openStream();){
            ObjectMapper objectMapper = new ObjectMapper();
            BatchEngineUnitConfiguration batchEngineUnitConfiguration = (BatchEngineUnitConfiguration)objectMapper.readValue(inputStream, BatchEngineUnitConfiguration.class);
            return batchEngineUnitConfiguration;
        }
    }

    public InputStream getConfigurationInputStream() throws IOException {
        return this._configurationURL.openStream();
    }

    public String getDataFileName() {
        return this._dataURL.getPath();
    }

    public InputStream getDataInputStream() throws IOException {
        return this._dataURL.openStream();
    }

    public String getFileName() {
        return this._bundle.toString();
    }

    public boolean isValid() {
        return this._configurationURL != null && this._dataURL != null;
    }

    private boolean _isBatchEngineConfiguration(String bundlePath) {
        return Objects.equals(bundlePath, "batch-engine.json") || bundlePath.endsWith("/batch-engine.json");
    }
}

