/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.bundle;

import com.liferay.batch.engine.internal.bundle.AdvancedBatchEngineBundleUnitImpl;
import com.liferay.batch.engine.internal.bundle.ClassicBatchEngineBundleUnitImpl;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitProcessor;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={})
public class BatchEngineBundleTracker {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private BatchEngineUnitProcessor _batchEngineUnitProcessor;
    private BundleTracker<Void> _bundleTracker;

    public boolean isBatchEngineTechnical(String zipEntryName) {
        return zipEntryName.endsWith(".batch-engine-data.json");
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)new BatchEngineBundleTrackerCustomizer());
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private String _getBatchEngineBundleEntryKey(URL url) {
        String zipEntryName = url.getPath();
        if (this.isBatchEngineTechnical(zipEntryName)) {
            return zipEntryName;
        }
        if (!zipEntryName.contains("/")) {
            return "";
        }
        return zipEntryName.substring(0, zipEntryName.lastIndexOf("/"));
    }

    private Collection<BatchEngineUnit> _getBatchEngineBundleUnitsCollection(Bundle bundle, String batchPath) {
        HashMap<String, URL> batchEngineURLs = new HashMap<String, URL>();
        HashMap<String, Object> batchEngineUnits = new HashMap<String, Object>();
        Enumeration enumeration = bundle.findEntries(batchPath, "*", true);
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            if (StringUtil.endsWith((String)url.getPath(), (String)"/")) continue;
            String key = this._getBatchEngineBundleEntryKey(url);
            URL complementURL = (URL)batchEngineURLs.get(key);
            if (complementURL == null) {
                batchEngineURLs.put(key, url);
                batchEngineUnits.put(key, new AdvancedBatchEngineBundleUnitImpl(bundle, url));
                continue;
            }
            batchEngineUnits.put(key, new ClassicBatchEngineBundleUnitImpl(bundle, url, complementURL));
            batchEngineURLs.remove(key);
        }
        return batchEngineUnits.values();
    }

    private Iterable<BatchEngineUnit> _getBatchEngineUnits(final Bundle bundle, final String batchPath) {
        return new Iterable<BatchEngineUnit>(){

            @Override
            public Iterator<BatchEngineUnit> iterator() {
                return new BatchEngineUnitIterator(bundle, batchPath);
            }
        };
    }

    private boolean _isAlreadyProcessed(Bundle bundle) {
        String lastModifiedString = String.valueOf(bundle.getLastModified());
        File batchMarkerFile = bundle.getDataFile(".liferay-client-extension-batch");
        try {
            if (batchMarkerFile != null && batchMarkerFile.exists() && Objects.equals(FileUtil.read((File)batchMarkerFile), lastModifiedString)) {
                return true;
            }
            if (!batchMarkerFile.exists()) {
                batchMarkerFile.createNewFile();
            }
            FileUtil.write((File)batchMarkerFile, (String)lastModifiedString, (boolean)true);
        }
        catch (IOException ioException) {
            ReflectionUtil.throwException((Throwable)ioException);
        }
        return false;
    }

    private void _processBatchEngineBundle(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String batchPath = (String)headers.get("Liferay-Client-Extension-Batch");
        if (batchPath != null) {
            if (this._isAlreadyProcessed(bundle)) {
                return;
            }
            if (batchPath.isEmpty()) {
                batchPath = ".";
            }
            if (StringUtil.startsWith((String)batchPath, (String)"/")) {
                batchPath = batchPath.substring(1);
            }
            if (!StringUtil.endsWith((String)batchPath, (String)"/")) {
                batchPath = batchPath.concat("/");
            }
            this._batchEngineUnitProcessor.processBatchEngineUnits(this._getBatchEngineUnits(bundle, batchPath));
        }
    }

    private class BatchEngineUnitIterator
    implements Iterator<BatchEngineUnit> {
        private final Iterator<BatchEngineUnit> _iterator;

        public BatchEngineUnitIterator(Bundle bundle, String batchPath) {
            Collection batchEngineZipUnits = BatchEngineBundleTracker.this._getBatchEngineBundleUnitsCollection(bundle, batchPath);
            this._iterator = batchEngineZipUnits.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public BatchEngineUnit next() {
            return this._iterator.next();
        }
    }

    private class BatchEngineBundleTrackerCustomizer
    implements BundleTrackerCustomizer<Void> {
        private BatchEngineBundleTrackerCustomizer() {
        }

        public Void addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            BatchEngineBundleTracker.this._processBatchEngineBundle(bundle);
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Void unused) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Void unused) {
        }
    }
}

