/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.bundle;

import com.liferay.batch.engine.internal.json.AdvancedJSONReader;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.osgi.framework.Bundle;

public class AdvancedBatchEngineBundleUnitImpl
implements BatchEngineUnit {
    private static final Log _log = LogFactoryUtil.getLog(AdvancedBatchEngineBundleUnitImpl.class);
    private final Bundle _bundle;
    private URL _url;

    public AdvancedBatchEngineBundleUnitImpl(Bundle bundle, URL url) {
        this._bundle = bundle;
        this._url = url;
    }

    public BatchEngineUnitConfiguration getBatchEngineUnitConfiguration() throws IOException {
        try (InputStream inputStream = this._url.openStream();){
            AdvancedJSONReader<BatchEngineUnitConfiguration> advancedJSONReader = new AdvancedJSONReader<BatchEngineUnitConfiguration>(inputStream);
            BatchEngineUnitConfiguration batchEngineUnitConfiguration = advancedJSONReader.getObject("configuration", BatchEngineUnitConfiguration.class);
            return batchEngineUnitConfiguration;
        }
    }

    public InputStream getConfigurationInputStream() throws IOException {
        return this._url.openStream();
    }

    public String getDataFileName() {
        return this._url.getPath();
    }

    public InputStream getDataInputStream() throws IOException {
        try (InputStream inputStream = this._url.openStream();){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(inputStream);
            advancedJSONReader.transferJSONArray("items", byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    public String getFileName() {
        return this._bundle.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid() {
        if (this._url == null) {
            return false;
        }
        try (InputStream inputStream = this._url.openStream();){
            AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(inputStream);
            boolean bl = advancedJSONReader.hasKey("items");
            return bl;
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to get data in file " + this._url.getPath()), (Throwable)ioException);
            return false;
        }
    }
}

