/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.model.impl;

import com.liferay.batch.engine.model.BatchEngineImportTaskError;
import com.liferay.batch.engine.model.BatchEngineImportTaskErrorModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the BatchEngineImportTaskError service. Represents a row in the &quot;BatchEngineImportTaskError&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>BatchEngineImportTaskErrorModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BatchEngineImportTaskErrorImpl}.
 * </p>
 *
 * @author Shuyang Zhou
 * @see BatchEngineImportTaskErrorImpl
 * @generated
 */
public class BatchEngineImportTaskErrorModelImpl
	extends BaseModelImpl<BatchEngineImportTaskError>
	implements BatchEngineImportTaskErrorModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a batch engine import task error model instance should use the <code>BatchEngineImportTaskError</code> interface instead.
	 */
	public static final String TABLE_NAME = "BatchEngineImportTaskError";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT},
		{"batchEngineImportTaskErrorId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"batchEngineImportTaskId", Types.BIGINT}, {"item", Types.CLOB},
		{"itemIndex", Types.INTEGER}, {"message", Types.CLOB}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("batchEngineImportTaskErrorId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("batchEngineImportTaskId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("item", Types.CLOB);
		TABLE_COLUMNS_MAP.put("itemIndex", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("message", Types.CLOB);
	}

	public static final String TABLE_SQL_CREATE =
		"create table BatchEngineImportTaskError (mvccVersion LONG default 0 not null,batchEngineImportTaskErrorId LONG not null primary key,companyId LONG,userId LONG,createDate DATE null,modifiedDate DATE null,batchEngineImportTaskId LONG,item TEXT null,itemIndex INTEGER,message TEXT null)";

	public static final String TABLE_SQL_DROP =
		"drop table BatchEngineImportTaskError";

	public static final String ORDER_BY_JPQL =
		" ORDER BY batchEngineImportTaskError.batchEngineImportTaskErrorId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY BatchEngineImportTaskError.batchEngineImportTaskErrorId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long BATCHENGINEIMPORTTASKID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long BATCHENGINEIMPORTTASKERRORID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public BatchEngineImportTaskErrorModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _batchEngineImportTaskErrorId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setBatchEngineImportTaskErrorId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _batchEngineImportTaskErrorId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return BatchEngineImportTaskError.class;
	}

	@Override
	public String getModelClassName() {
		return BatchEngineImportTaskError.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<BatchEngineImportTaskError, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<BatchEngineImportTaskError, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BatchEngineImportTaskError, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(BatchEngineImportTaskError)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<BatchEngineImportTaskError, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<BatchEngineImportTaskError, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(BatchEngineImportTaskError)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<BatchEngineImportTaskError, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<BatchEngineImportTaskError, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<BatchEngineImportTaskError, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<BatchEngineImportTaskError, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String,
						 Function<BatchEngineImportTaskError, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", BatchEngineImportTaskError::getMvccVersion);
			attributeGetterFunctions.put(
				"batchEngineImportTaskErrorId",
				BatchEngineImportTaskError::getBatchEngineImportTaskErrorId);
			attributeGetterFunctions.put(
				"companyId", BatchEngineImportTaskError::getCompanyId);
			attributeGetterFunctions.put(
				"userId", BatchEngineImportTaskError::getUserId);
			attributeGetterFunctions.put(
				"createDate", BatchEngineImportTaskError::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", BatchEngineImportTaskError::getModifiedDate);
			attributeGetterFunctions.put(
				"batchEngineImportTaskId",
				BatchEngineImportTaskError::getBatchEngineImportTaskId);
			attributeGetterFunctions.put(
				"item", BatchEngineImportTaskError::getItem);
			attributeGetterFunctions.put(
				"itemIndex", BatchEngineImportTaskError::getItemIndex);
			attributeGetterFunctions.put(
				"message", BatchEngineImportTaskError::getMessage);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<BatchEngineImportTaskError, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<BatchEngineImportTaskError, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<BatchEngineImportTaskError, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<BatchEngineImportTaskError, Long>)
					BatchEngineImportTaskError::setMvccVersion);
			attributeSetterBiConsumers.put(
				"batchEngineImportTaskErrorId",
				(BiConsumer<BatchEngineImportTaskError, Long>)
					BatchEngineImportTaskError::
						setBatchEngineImportTaskErrorId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<BatchEngineImportTaskError, Long>)
					BatchEngineImportTaskError::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<BatchEngineImportTaskError, Long>)
					BatchEngineImportTaskError::setUserId);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<BatchEngineImportTaskError, Date>)
					BatchEngineImportTaskError::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<BatchEngineImportTaskError, Date>)
					BatchEngineImportTaskError::setModifiedDate);
			attributeSetterBiConsumers.put(
				"batchEngineImportTaskId",
				(BiConsumer<BatchEngineImportTaskError, Long>)
					BatchEngineImportTaskError::setBatchEngineImportTaskId);
			attributeSetterBiConsumers.put(
				"item",
				(BiConsumer<BatchEngineImportTaskError, String>)
					BatchEngineImportTaskError::setItem);
			attributeSetterBiConsumers.put(
				"itemIndex",
				(BiConsumer<BatchEngineImportTaskError, Integer>)
					BatchEngineImportTaskError::setItemIndex);
			attributeSetterBiConsumers.put(
				"message",
				(BiConsumer<BatchEngineImportTaskError, String>)
					BatchEngineImportTaskError::setMessage);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getBatchEngineImportTaskErrorId() {
		return _batchEngineImportTaskErrorId;
	}

	@Override
	public void setBatchEngineImportTaskErrorId(
		long batchEngineImportTaskErrorId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_batchEngineImportTaskErrorId = batchEngineImportTaskErrorId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getBatchEngineImportTaskId() {
		return _batchEngineImportTaskId;
	}

	@Override
	public void setBatchEngineImportTaskId(long batchEngineImportTaskId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_batchEngineImportTaskId = batchEngineImportTaskId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalBatchEngineImportTaskId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("batchEngineImportTaskId"));
	}

	@Override
	public String getItem() {
		if (_item == null) {
			return "";
		}
		else {
			return _item;
		}
	}

	@Override
	public void setItem(String item) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_item = item;
	}

	@Override
	public int getItemIndex() {
		return _itemIndex;
	}

	@Override
	public void setItemIndex(int itemIndex) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_itemIndex = itemIndex;
	}

	@Override
	public String getMessage() {
		if (_message == null) {
			return "";
		}
		else {
			return _message;
		}
	}

	@Override
	public void setMessage(String message) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_message = message;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), BatchEngineImportTaskError.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public BatchEngineImportTaskError toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, BatchEngineImportTaskError>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		BatchEngineImportTaskErrorImpl batchEngineImportTaskErrorImpl =
			new BatchEngineImportTaskErrorImpl();

		batchEngineImportTaskErrorImpl.setMvccVersion(getMvccVersion());
		batchEngineImportTaskErrorImpl.setBatchEngineImportTaskErrorId(
			getBatchEngineImportTaskErrorId());
		batchEngineImportTaskErrorImpl.setCompanyId(getCompanyId());
		batchEngineImportTaskErrorImpl.setUserId(getUserId());
		batchEngineImportTaskErrorImpl.setCreateDate(getCreateDate());
		batchEngineImportTaskErrorImpl.setModifiedDate(getModifiedDate());
		batchEngineImportTaskErrorImpl.setBatchEngineImportTaskId(
			getBatchEngineImportTaskId());
		batchEngineImportTaskErrorImpl.setItem(getItem());
		batchEngineImportTaskErrorImpl.setItemIndex(getItemIndex());
		batchEngineImportTaskErrorImpl.setMessage(getMessage());

		batchEngineImportTaskErrorImpl.resetOriginalValues();

		return batchEngineImportTaskErrorImpl;
	}

	@Override
	public BatchEngineImportTaskError cloneWithOriginalValues() {
		BatchEngineImportTaskErrorImpl batchEngineImportTaskErrorImpl =
			new BatchEngineImportTaskErrorImpl();

		batchEngineImportTaskErrorImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		batchEngineImportTaskErrorImpl.setBatchEngineImportTaskErrorId(
			this.<Long>getColumnOriginalValue("batchEngineImportTaskErrorId"));
		batchEngineImportTaskErrorImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		batchEngineImportTaskErrorImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		batchEngineImportTaskErrorImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		batchEngineImportTaskErrorImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		batchEngineImportTaskErrorImpl.setBatchEngineImportTaskId(
			this.<Long>getColumnOriginalValue("batchEngineImportTaskId"));
		batchEngineImportTaskErrorImpl.setItem(
			this.<String>getColumnOriginalValue("item"));
		batchEngineImportTaskErrorImpl.setItemIndex(
			this.<Integer>getColumnOriginalValue("itemIndex"));
		batchEngineImportTaskErrorImpl.setMessage(
			this.<String>getColumnOriginalValue("message"));

		return batchEngineImportTaskErrorImpl;
	}

	@Override
	public int compareTo(
		BatchEngineImportTaskError batchEngineImportTaskError) {

		long primaryKey = batchEngineImportTaskError.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof BatchEngineImportTaskError)) {
			return false;
		}

		BatchEngineImportTaskError batchEngineImportTaskError =
			(BatchEngineImportTaskError)object;

		long primaryKey = batchEngineImportTaskError.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<BatchEngineImportTaskError> toCacheModel() {
		BatchEngineImportTaskErrorCacheModel
			batchEngineImportTaskErrorCacheModel =
				new BatchEngineImportTaskErrorCacheModel();

		batchEngineImportTaskErrorCacheModel.mvccVersion = getMvccVersion();

		batchEngineImportTaskErrorCacheModel.batchEngineImportTaskErrorId =
			getBatchEngineImportTaskErrorId();

		batchEngineImportTaskErrorCacheModel.companyId = getCompanyId();

		batchEngineImportTaskErrorCacheModel.userId = getUserId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			batchEngineImportTaskErrorCacheModel.createDate =
				createDate.getTime();
		}
		else {
			batchEngineImportTaskErrorCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			batchEngineImportTaskErrorCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			batchEngineImportTaskErrorCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		batchEngineImportTaskErrorCacheModel.batchEngineImportTaskId =
			getBatchEngineImportTaskId();

		batchEngineImportTaskErrorCacheModel.item = getItem();

		String item = batchEngineImportTaskErrorCacheModel.item;

		if ((item != null) && (item.length() == 0)) {
			batchEngineImportTaskErrorCacheModel.item = null;
		}

		batchEngineImportTaskErrorCacheModel.itemIndex = getItemIndex();

		batchEngineImportTaskErrorCacheModel.message = getMessage();

		String message = batchEngineImportTaskErrorCacheModel.message;

		if ((message != null) && (message.length() == 0)) {
			batchEngineImportTaskErrorCacheModel.message = null;
		}

		return batchEngineImportTaskErrorCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<BatchEngineImportTaskError, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<BatchEngineImportTaskError, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BatchEngineImportTaskError, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(BatchEngineImportTaskError)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, BatchEngineImportTaskError>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						BatchEngineImportTaskError.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _batchEngineImportTaskErrorId;
	private long _companyId;
	private long _userId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _batchEngineImportTaskId;
	private String _item;
	private int _itemIndex;
	private String _message;

	public <T> T getColumnValue(String columnName) {
		Function<BatchEngineImportTaskError, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((BatchEngineImportTaskError)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"batchEngineImportTaskErrorId", _batchEngineImportTaskErrorId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"batchEngineImportTaskId", _batchEngineImportTaskId);
		_columnOriginalValues.put("item", _item);
		_columnOriginalValues.put("itemIndex", _itemIndex);
		_columnOriginalValues.put("message", _message);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("batchEngineImportTaskErrorId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("createDate", 16L);

		columnBitmasks.put("modifiedDate", 32L);

		columnBitmasks.put("batchEngineImportTaskId", 64L);

		columnBitmasks.put("item", 128L);

		columnBitmasks.put("itemIndex", 256L);

		columnBitmasks.put("message", 512L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private BatchEngineImportTaskError _escapedModel;

}