/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.model.impl;

import com.liferay.petra.string.StringPool;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.util.Collections;
import java.util.List;

/**
 * @author Ivica Cardic
 */
public class BatchEngineExportTaskImpl extends BatchEngineExportTaskBaseImpl {

	@Override
	public List<String> getFieldNamesList() {
		if (Validator.isNull(getFieldNames())) {
			return Collections.emptyList();
		}

		return StringUtil.split(getFieldNames());
	}

	@Override
	public void setFieldNamesList(List<String> fieldNamesList) {
		setFieldNames(StringUtil.merge(fieldNamesList, StringPool.COMMA));
	}

}