/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.internal.reader;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * @author Igor Beslic
 */
public class FieldNameFilterFunction
	implements Function<Map<String, Object>, Map<String, Object>> {

	public FieldNameFilterFunction(List<String> includeNames) {
		_includeNames = Collections.unmodifiableList(includeNames);
	}

	@Override
	public Map<String, Object> apply(Map<String, Object> map) {
		Map<String, Object> filteredMap = new HashMap<>();

		for (String name : _includeNames) {
			filteredMap.put(name, map.get(name));
		}

		return filteredMap;
	}

	private final List<String> _includeNames;

}