/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.internal.installer;

import com.liferay.batch.engine.internal.json.AdvancedJSONReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 * @author Igor Beslic
 */
public class AdvancedBatchEngineZipUnitImpl<T>
	implements BatchEngineZipUnit<T> {

	public AdvancedBatchEngineZipUnitImpl(ZipFile zipFile, ZipEntry zipEntry) {
		_zipFile = zipFile;
		_zipEntry = zipEntry;
	}

	@Override
	public T getBatchEngineConfiguration(Class<T> clazz) throws IOException {
		try (InputStream inputStream = _zipFile.getInputStream(_zipEntry)) {
			AdvancedJSONReader<T> advancedJSONReader = new AdvancedJSONReader<>(
				inputStream);

			return advancedJSONReader.getObject("configuration", clazz);
		}
	}

	@Override
	public InputStream getConfigurationInputStream() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String getDataFileName() {
		return _zipEntry.getName();
	}

	@Override
	public InputStream getDataInputStream() throws IOException {
		try (InputStream inputStream = _zipFile.getInputStream(_zipEntry)) {
			ByteArrayOutputStream byteArrayOutputStream =
				new ByteArrayOutputStream();

			AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(
				inputStream);

			advancedJSONReader.transferJSONArray(
				"items", byteArrayOutputStream);

			return new ByteArrayInputStream(
				byteArrayOutputStream.toByteArray());
		}
	}

	@Override
	public String getZipFileName() {
		return _zipFile.getName();
	}

	@Override
	public boolean isValid() {
		if (_zipEntry == null) {
			return false;
		}

		try (InputStream inputStream = _zipFile.getInputStream(_zipEntry)) {
			AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(
				inputStream);

			return advancedJSONReader.hasKey("items");
		}
		catch (IOException ioException) {
			_log.error(
				"Unable to get data in file " + _zipEntry.getName(),
				ioException);
		}

		return false;
	}

	private static final Log _log = LogFactoryUtil.getLog(
		AdvancedBatchEngineZipUnitImpl.class);

	private ZipEntry _zipEntry;
	private final ZipFile _zipFile;

}