/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.internal.bundle;

import com.liferay.batch.engine.internal.json.AdvancedJSONReader;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import java.net.URL;

import org.osgi.framework.Bundle;

/**
 * @author Raymond Augé
 * @author Igor Beslic
 */
public class AdvancedBatchEngineBundleUnitImpl implements BatchEngineUnit {

	public AdvancedBatchEngineBundleUnitImpl(Bundle bundle, URL url) {
		_bundle = bundle;
		_url = url;
	}

	public BatchEngineUnitConfiguration getBatchEngineUnitConfiguration()
		throws IOException {

		try (InputStream inputStream = _url.openStream()) {
			AdvancedJSONReader<BatchEngineUnitConfiguration>
				advancedJSONReader = new AdvancedJSONReader<>(inputStream);

			return advancedJSONReader.getObject(
				"configuration", BatchEngineUnitConfiguration.class);
		}
	}

	@Override
	public InputStream getConfigurationInputStream() throws IOException {
		return _url.openStream();
	}

	@Override
	public String getDataFileName() {
		return _url.getPath();
	}

	@Override
	public InputStream getDataInputStream() throws IOException {
		try (InputStream inputStream = _url.openStream()) {
			ByteArrayOutputStream byteArrayOutputStream =
				new ByteArrayOutputStream();

			AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(
				inputStream);

			advancedJSONReader.transferJSONArray(
				"items", byteArrayOutputStream);

			return new ByteArrayInputStream(
				byteArrayOutputStream.toByteArray());
		}
	}

	@Override
	public String getFileName() {
		return _bundle.toString();
	}

	@Override
	public boolean isValid() {
		if (_url == null) {
			return false;
		}

		try (InputStream inputStream = _url.openStream()) {
			AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(
				inputStream);

			return advancedJSONReader.hasKey("items");
		}
		catch (IOException ioException) {
			_log.error(
				"Unable to get data in file " + _url.getPath(), ioException);
		}

		return false;
	}

	private static final Log _log = LogFactoryUtil.getLog(
		AdvancedBatchEngineBundleUnitImpl.class);

	private final Bundle _bundle;
	private URL _url;

}