/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.batch.engine.internal.writer.ItemClassIndexUtil;
import com.liferay.petra.function.UnsafeFunction;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ColumnValuesExtractor {
    private final List<UnsafeFunction<Object, Object, ReflectiveOperationException>> _unsafeFunctions;

    public ColumnValuesExtractor(Map<String, Field> fieldMap, List<String> fieldNames) {
        ArrayList<UnsafeFunction<Object, Object, ReflectiveOperationException>> unsafeFunctions = new ArrayList<UnsafeFunction<Object, Object, ReflectiveOperationException>>(fieldNames.size());
        for (String fieldName : fieldNames) {
            int index;
            Field field = fieldMap.get(fieldName);
            if (field != null) {
                if (ItemClassIndexUtil.isSingleColumnAdoptableValue(field.getType())) {
                    unsafeFunctions.add((UnsafeFunction<Object, Object, ReflectiveOperationException>)((UnsafeFunction)item -> {
                        if (field.get(item) == null) {
                            return "";
                        }
                        return field.get(item);
                    }));
                    continue;
                }
                if (ItemClassIndexUtil.isSingleColumnAdoptableArray(field.getType())) {
                    unsafeFunctions.add((UnsafeFunction<Object, Object, ReflectiveOperationException>)((UnsafeFunction)item -> ""));
                    continue;
                }
            }
            if ((index = fieldName.indexOf(95)) == -1) {
                throw new IllegalArgumentException("Invalid field name : " + fieldName);
            }
            String prefixFieldName = fieldName.substring(0, index);
            Field mapField = fieldMap.get(prefixFieldName);
            if (mapField == null) {
                throw new IllegalArgumentException("Invalid field name : " + fieldName);
            }
            if (mapField.getType() != Map.class) {
                throw new IllegalArgumentException("Invalid field name : " + fieldName + ", it is not Map type.");
            }
            String key = fieldName.substring(index + 1);
            unsafeFunctions.add((UnsafeFunction<Object, Object, ReflectiveOperationException>)((UnsafeFunction)item -> {
                Map map = (Map)mapField.get(item);
                Object value = map.get(key);
                if (value == null) {
                    return "";
                }
                return value;
            }));
        }
        this._unsafeFunctions = unsafeFunctions;
    }

    public List<Object> extractValues(Object item) throws ReflectiveOperationException {
        ArrayList<Object> values = new ArrayList<Object>(this._unsafeFunctions.size());
        for (UnsafeFunction<Object, Object, ReflectiveOperationException> unsafeFunction : this._unsafeFunctions) {
            values.add(unsafeFunction.apply(item));
        }
        return values;
    }
}

