/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.internal.util;

import com.liferay.petra.lang.CentralizedThreadLocal;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Matija Petanjek
 */
public class ItemIndexThreadLocal {

	public static int get(Object item) {
		Map<Object, Integer> itemIndexMap = _itemIndexMap.get();

		return itemIndexMap.get(item);
	}

	public static void put(Object item, int itemIndex) {
		Map<Object, Integer> itemIndexMap = _itemIndexMap.get();

		itemIndexMap.put(item, itemIndex);
	}

	public static void remove() {
		_itemIndexMap.remove();
	}

	private static final ThreadLocal<Map<Object, Integer>> _itemIndexMap =
		new CentralizedThreadLocal<>(
			ItemIndexThreadLocal.class + "._itemIndexMap", HashMap::new);

}