/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.task.progress;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.internal.task.progress.BatchEngineTaskProgress;
import com.liferay.batch.engine.internal.task.progress.CSVBatchEngineTaskProgressImpl;
import com.liferay.batch.engine.internal.task.progress.JSONBatchEngineTaskProgressImpl;
import com.liferay.batch.engine.internal.task.progress.JSONLBatchEngineTaskProgressImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.InputStream;

public class BatchEngineTaskProgressFactory {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineTaskProgressFactory.class);

    public BatchEngineTaskProgress create(BatchEngineTaskContentType batchEngineTaskContentType) {
        if (batchEngineTaskContentType == BatchEngineTaskContentType.CSV) {
            return new CSVBatchEngineTaskProgressImpl();
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSON) {
            return new JSONBatchEngineTaskProgressImpl();
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSONL) {
            return new JSONLBatchEngineTaskProgressImpl();
        }
        return new DefaultBatchEngineTaskProgressImpl();
    }

    private class DefaultBatchEngineTaskProgressImpl
    implements BatchEngineTaskProgress {
        private DefaultBatchEngineTaskProgressImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getTotalItemsCount(InputStream inputStream) {
            try {
                int n = 0;
                return n;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ioException) {
                    _log.error((Object)"Unable to close input stream", (Throwable)ioException);
                }
            }
        }
    }
}

