/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration;
import com.liferay.batch.engine.internal.BatchEngineTaskCallbackUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskExecutorUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskMethodRegistry;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutor;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutorFactory;
import com.liferay.batch.engine.internal.notification.BatchEngineNotificationSender;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderFactory;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderUtil;
import com.liferay.batch.engine.internal.task.progress.BatchEngineTaskProgress;
import com.liferay.batch.engine.internal.task.progress.BatchEngineTaskProgressFactory;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration"}, service={BatchEngineImportTaskExecutor.class})
public class BatchEngineImportTaskExecutorImpl
extends BatchEngineNotificationSender
implements BatchEngineImportTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineImportTaskExecutorImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private BatchEngineImportTaskItemReaderFactory _batchEngineImportTaskItemReaderFactory;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    private BatchEngineTaskItemDelegateExecutorFactory _batchEngineTaskItemDelegateExecutorFactory;
    @Reference
    private BatchEngineTaskMethodRegistry _batchEngineTaskMethodRegistry;
    private BatchEngineTaskProgressFactory _batchEngineTaskProgressFactory;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public void execute(BatchEngineImportTask batchEngineImportTask) {
        try {
            batchEngineImportTask.setExecuteStatus(BatchEngineTaskExecuteStatus.STARTED.toString());
            batchEngineImportTask.setStartTime(new Date());
            BatchEngineTaskProgress batchEngineTaskProgress = this._batchEngineTaskProgressFactory.create(BatchEngineTaskContentType.valueOf((String)batchEngineImportTask.getContentType()));
            batchEngineImportTask.setTotalItemsCount(batchEngineTaskProgress.getTotalItemsCount(this._batchEngineImportTaskLocalService.openContentInputStream(batchEngineImportTask.getBatchEngineImportTaskId())));
            this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
            BatchEngineTaskExecutorUtil.execute((UnsafeRunnable<Throwable>)((UnsafeRunnable)() -> this._importItems(batchEngineImportTask)), this._userLocalService.getUser(batchEngineImportTask.getUserId()));
            this._updateBatchEngineImportTask(BatchEngineTaskExecuteStatus.COMPLETED, batchEngineImportTask, null);
            this.sendUserNotificationEvents(batchEngineImportTask.getUserId(), "com_liferay_batch_engine_web_internal_portlet_BatchEnginePortlet", 10002, this.getNotificationEventJSONObject(BatchEngineTaskExecuteStatus.COMPLETED, batchEngineImportTask.getClassName()));
        }
        catch (Throwable throwable) {
            _log.error((Object)("Unable to update batch engine import task " + batchEngineImportTask), throwable);
            this._updateBatchEngineImportTask(BatchEngineTaskExecuteStatus.FAILED, batchEngineImportTask, throwable.getMessage());
            this.sendUserNotificationEvents(batchEngineImportTask.getUserId(), "com_liferay_batch_engine_web_internal_portlet_BatchEnginePortlet", 10002, this.getNotificationEventJSONObject(BatchEngineTaskExecuteStatus.FAILED, batchEngineImportTask.getClassName()));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        BatchEngineTaskConfiguration batchEngineTaskConfiguration = (BatchEngineTaskConfiguration)ConfigurableUtil.createConfigurable(BatchEngineTaskConfiguration.class, properties);
        this._batchEngineImportTaskItemReaderFactory = new BatchEngineImportTaskItemReaderFactory(GetterUtil.getString((String)batchEngineTaskConfiguration.csvFileColumnDelimiter(), (String)","));
        this._batchEngineTaskProgressFactory = new BatchEngineTaskProgressFactory();
        this._batchEngineTaskItemDelegateExecutorFactory = new BatchEngineTaskItemDelegateExecutorFactory(this._batchEngineTaskMethodRegistry, null, null, null);
        this.setUserNotificationEventLocalService(this._userNotificationEventLocalService);
    }

    @Override
    protected String getTaskType() {
        return "import";
    }

    protected JSONObject populateNotificationEventJSONObject(String className) {
        JSONObject notificationEventJSONObject = JSONFactoryUtil.createJSONObject();
        return notificationEventJSONObject.put("batchEngineTaskType", "import").put("className", className);
    }

    private void _commitItems(BatchEngineImportTask batchEngineImportTask, BatchEngineTaskItemDelegateExecutor batchEngineTaskItemDelegateExecutor, List<Object> items) throws Throwable {
        TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
            batchEngineTaskItemDelegateExecutor.saveItems(BatchEngineTaskOperation.valueOf((String)batchEngineImportTask.getOperation()), items);
            batchEngineImportTask.setProcessedItemsCount(batchEngineImportTask.getProcessedItemsCount() + items.size());
            this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
            return null;
        });
    }

    private void _importItems(BatchEngineImportTask batchEngineImportTask) throws Throwable {
        Map<String, Serializable> parameters = batchEngineImportTask.getParameters();
        if (parameters == null) {
            parameters = Collections.emptyMap();
        }
        try (BatchEngineImportTaskItemReader batchEngineImportTaskItemReader = this._batchEngineImportTaskItemReaderFactory.create(BatchEngineTaskContentType.valueOf((String)batchEngineImportTask.getContentType()), this._batchEngineImportTaskLocalService.openContentInputStream(batchEngineImportTask.getBatchEngineImportTaskId()), parameters);
             BatchEngineTaskItemDelegateExecutor batchEngineTaskItemDelegateExecutor = this._batchEngineTaskItemDelegateExecutorFactory.create(batchEngineImportTask.getTaskItemDelegateName(), batchEngineImportTask.getClassName(), this._companyLocalService.getCompany(batchEngineImportTask.getCompanyId()), parameters, this._userLocalService.getUser(batchEngineImportTask.getUserId()));){
            ArrayList<Object> items = new ArrayList<Object>();
            Class itemClass = this._batchEngineTaskMethodRegistry.getItemClass(batchEngineImportTask.getClassName());
            Map<String, Object> fieldNameValueMap = null;
            while ((fieldNameValueMap = batchEngineImportTaskItemReader.read()) != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                items.add(BatchEngineImportTaskItemReaderUtil.convertValue(itemClass, BatchEngineImportTaskItemReaderUtil.mapFieldNames(batchEngineImportTask.getFieldNameMapping(), fieldNameValueMap)));
                if ((long)items.size() != batchEngineImportTask.getBatchSize()) continue;
                this._commitItems(batchEngineImportTask, batchEngineTaskItemDelegateExecutor, items);
                items.clear();
            }
            if (!items.isEmpty()) {
                this._commitItems(batchEngineImportTask, batchEngineTaskItemDelegateExecutor, items);
            }
        }
    }

    private void _updateBatchEngineImportTask(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, BatchEngineImportTask batchEngineImportTask, String errorMessage) {
        batchEngineImportTask.setEndTime(new Date());
        batchEngineImportTask.setErrorMessage(errorMessage);
        batchEngineImportTask.setExecuteStatus(batchEngineTaskExecuteStatus.toString());
        this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
        BatchEngineTaskCallbackUtil.sendCallback(batchEngineImportTask.getCallbackURL(), batchEngineImportTask.getExecuteStatus(), batchEngineImportTask.getBatchEngineImportTaskId());
    }
}

