/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.model.impl;

import com.liferay.batch.engine.model.BatchEngineImportTaskError;
import com.liferay.batch.engine.service.BatchEngineImportTaskErrorLocalServiceUtil;

import java.util.List;

/**
 * The extended model implementation for the BatchEngineImportTask service.
 * Represents a row in the &quot;BatchEngineImportTask&quot; database table,
 * with each column mapped to a property of this class.
 *
 * <p>
 * Helper methods and all application logic should be put in this class.
 * Whenever methods are added, rerun ServiceBuilder to copy their definitions
 * into the <code>com.liferay.batch.engine.model.BatchEngineImportTask</code>
 * interface.
 * </p>
 *
 * @author Shuyang Zhou
 */
public class BatchEngineImportTaskImpl extends BatchEngineImportTaskBaseImpl {

	public List<BatchEngineImportTaskError> getBatchEngineImportTaskErrors() {
		return BatchEngineImportTaskErrorLocalServiceUtil.
			getBatchEngineImportTaskErrors(getBatchEngineImportTaskId());
	}

}