/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.model.impl;

import com.liferay.batch.engine.model.BatchEngineImportTaskError;
import com.liferay.batch.engine.service.BatchEngineImportTaskErrorLocalServiceUtil;

/**
 * The extended model base implementation for the BatchEngineImportTaskError service. Represents a row in the &quot;BatchEngineImportTaskError&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BatchEngineImportTaskErrorImpl}.
 * </p>
 *
 * @author Shuyang Zhou
 * @see BatchEngineImportTaskErrorImpl
 * @see BatchEngineImportTaskError
 * @generated
 */
public abstract class BatchEngineImportTaskErrorBaseImpl
	extends BatchEngineImportTaskErrorModelImpl
	implements BatchEngineImportTaskError {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a batch engine import task error model instance should use the <code>BatchEngineImportTaskError</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			BatchEngineImportTaskErrorLocalServiceUtil.
				addBatchEngineImportTaskError(this);
		}
		else {
			BatchEngineImportTaskErrorLocalServiceUtil.
				updateBatchEngineImportTaskError(this);
		}
	}

}