/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.internal.notification;

import com.liferay.batch.engine.constants.BatchEnginePortletKeys;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;

import org.osgi.service.component.annotations.Component;

/**
 * @author Igor Beslic
 */
@Component(
	immediate = true,
	property = "javax.portlet.name=" + BatchEnginePortletKeys.BATCH_ENGINE,
	service = UserNotificationHandler.class
)
public class BatchEngineUserNotificationHandler
	extends BaseUserNotificationHandler {

	public BatchEngineUserNotificationHandler() {
		setPortletId(BatchEnginePortletKeys.BATCH_ENGINE);
	}

	@Override
	protected String getBody(
			UserNotificationEvent userNotificationEvent,
			ServiceContext serviceContext)
		throws Exception {

		JSONObject jsonObject = JSONFactoryUtil.createJSONObject(
			userNotificationEvent.getPayload());

		String status = serviceContext.translate(
			jsonObject.getString("status"));
		String taskType = serviceContext.translate(
			jsonObject.getString("taskType"));

		return String.format(
			"<h2 class=\"title\">%s</h2><div class=\"body\">%s</div>",
			serviceContext.translate("x-batch-engine-task-x", taskType, status),
			serviceContext.translate(
				"x-batch-engine-task-for-x-x", taskType,
				jsonObject.getString("className"), status));
	}

}