/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.internal.notification;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;

/**
 * @author Igor Beslic
 */
public abstract class BatchEngineNotificationSender {

	protected JSONObject getNotificationEventJSONObject(
		BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus,
		String className) {

		JSONObject notificationEventJSONObject =
			JSONFactoryUtil.createJSONObject();

		return notificationEventJSONObject.put(
			"className", className
		).put(
			"status", batchEngineTaskExecuteStatus.name()
		).put(
			"taskType", getTaskType()
		);
	}

	protected abstract String getTaskType();

	protected void sendUserNotificationEvents(
		long userId, String portletId, int notificationType,
		JSONObject jsonObject) {

		try {
			_userNotificationEventLocalService.sendUserNotificationEvents(
				userId, portletId, notificationType, jsonObject);
		}
		catch (Exception exception) {
			_log.error("Unable to send user notification", exception);
		}
	}

	protected void setUserNotificationEventLocalService(
		UserNotificationEventLocalService userNotificationEventLocalService) {

		_userNotificationEventLocalService = userNotificationEventLocalService;
	}

	private static final Log _log = LogFactoryUtil.getLog(
		BatchEngineNotificationSender.class);

	private UserNotificationEventLocalService
		_userNotificationEventLocalService;

}