/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.instance.lifecycle;

import com.liferay.batch.engine.internal.unit.MultiCompanyBatchEngineUnitProcessor;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import java.util.concurrent.CompletableFuture;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=-2147483648"}, service={PortalInstanceLifecycleListener.class})
public class MultiCompanyBatchEngineUnitPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private MultiCompanyBatchEngineUnitProcessor _multiCompanyBatchEngineUnitProcessor;

    public void portalInstanceRegistered(Company company) throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.HYPERSONIC) {
            TransactionCommitCallbackUtil.registerCallback(() -> this._processBatchEngineUnits(company));
        } else {
            this._processBatchEngineUnits(company);
        }
    }

    public void portalInstanceUnregistered(Company company) {
        this._multiCompanyBatchEngineUnitProcessor.unregister(company);
    }

    private Void _processBatchEngineUnits(Company company) throws Exception {
        CompletableFuture<Void> completableFuture = this._multiCompanyBatchEngineUnitProcessor.processBatchEngineUnits(company);
        return completableFuture.get();
    }
}

