/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class BatchEngineTaskCallbackUtil {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineTaskCallbackUtil.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper();

    public static void sendCallback(String callbackURL, String executeStatus, long id) {
        if (Validator.isBlank((String)callbackURL)) {
            return;
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        try (CloseableHttpClient closeableHttpClient = httpClientBuilder.useSystemProperties().build();){
            HttpPost httpPost = new HttpPost(callbackURL);
            httpPost.setEntity((HttpEntity)new StringEntity(_objectMapper.writeValueAsString(Collections.singletonMap(id, executeStatus)), ContentType.APPLICATION_JSON));
            closeableHttpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }
}

