/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.ItemClassRegistry;
import com.liferay.batch.engine.internal.writer.BatchEngineTaskItemDelegateProvider;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={ItemClassRegistry.class})
public class ItemClassRegistryImpl
implements ItemClassRegistry {
    @Reference
    private BatchEngineTaskItemDelegateProvider _batchEngineTaskItemDelegateProvider;
    private ServiceTrackerMap<String, Class<?>> _serviceTrackerMap;

    public Class<?> getItemClass(BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate) {
        Class<?> itemClass = batchEngineTaskItemDelegate.getItemClass();
        if (itemClass != null) {
            return itemClass;
        }
        Class batchEngineTaskItemDelegateClass = batchEngineTaskItemDelegate.getClass();
        itemClass = this._getItemClassFromGenericInterfaces(batchEngineTaskItemDelegateClass.getGenericInterfaces());
        if (itemClass == null) {
            itemClass = this._getItemClassFromGenericSuperclass(batchEngineTaskItemDelegateClass.getGenericSuperclass());
        }
        if (itemClass == null) {
            throw new IllegalStateException(BatchEngineTaskItemDelegate.class.getName() + " is not implemented");
        }
        return itemClass;
    }

    public Class<?> getItemClass(String itemClassName) {
        Class itemClass = (Class)this._serviceTrackerMap.getService((Object)itemClassName);
        if (itemClass == null) {
            throw new IllegalStateException("Unknown class: " + itemClassName);
        }
        return itemClass;
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, null, (String)("(|(batch.engine.task.item.delegate=true)(objectClass=" + BatchEngineTaskItemDelegate.class.getName() + "))"), (serviceReference, emitter) -> {
            try {
                Class<?> itemClass = this._getItemClass(bundleContext, serviceReference);
                emitter.emit((Object)itemClass.getName());
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<BatchEngineTaskItemDelegate<Object>, Class<?>>(){

            public Class<?> addingService(ServiceReference<BatchEngineTaskItemDelegate<Object>> serviceReference) {
                return ItemClassRegistryImpl.this._getItemClass(bundleContext, serviceReference);
            }

            public void modifiedService(ServiceReference<BatchEngineTaskItemDelegate<Object>> serviceReference, Class<?> itemClass) {
            }

            public void removedService(ServiceReference<BatchEngineTaskItemDelegate<Object>> serviceReference, Class<?> itemClass) {
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private Class<?> _getItemClass(BundleContext bundleContext, ServiceReference<?> serviceReference) {
        BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate = this._batchEngineTaskItemDelegateProvider.toBatchEngineTaskItemDelegate(bundleContext.getService(serviceReference));
        return this.getItemClass(batchEngineTaskItemDelegate);
    }

    private Class<?> _getItemClass(ParameterizedType parameterizedType) {
        Type[] genericTypes = parameterizedType.getActualTypeArguments();
        return (Class)genericTypes[0];
    }

    private Class<?> _getItemClassFromGenericInterfaces(Type[] genericInterfaceTypes) {
        for (Type genericInterfaceType : genericInterfaceTypes) {
            ParameterizedType parameterizedType;
            if (!(genericInterfaceType instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)genericInterfaceType).getRawType() != BatchEngineTaskItemDelegate.class) continue;
            return this._getItemClass(parameterizedType);
        }
        return null;
    }

    private Class<?> _getItemClassFromGenericSuperclass(Type genericSuperclassType) {
        if (genericSuperclassType == null) {
            return null;
        }
        return this._getItemClass((ParameterizedType)genericSuperclassType);
    }
}

