/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.installer;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.internal.installer.AdvancedZipBatchEngineUnitImpl;
import com.liferay.batch.engine.internal.installer.ClassicZipBatchEngineUnitImpl;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.batch.engine.unit.BatchEngineUnitProcessor;
import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FileInstaller.class})
public class BatchEngineFileInstaller
implements FileInstaller {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineFileInstaller.class);
    @Reference
    private BatchEngineUnitProcessor _batchEngineUnitProcessor;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canTransformURL(File file) {
        String fileName = file.getName();
        if (!StringUtil.endsWith((String)fileName, (String)".zip")) return false;
        if (this._isClientExtension(file)) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            BatchEngineUnitConfiguration batchEngineUnitConfiguration;
            BatchEngineUnit batchEngineUnit;
            Iterator<BatchEngineUnit> iterator = this._getBatchEngineUnitsCollection(zipFile).iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(batchEngineUnit = iterator.next()).isValid() || (batchEngineUnitConfiguration = this._getBatchEngineUnitConfiguration(batchEngineUnit)) == null || batchEngineUnitConfiguration.getCompanyId() <= 0L || batchEngineUnitConfiguration.getUserId() <= 0L || !Validator.isNotNull((String)batchEngineUnitConfiguration.getClassName()) || !Validator.isNotNull((String)batchEngineUnitConfiguration.getVersion()));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return false;
            _log.debug((Throwable)new AutoDeployException((Throwable)exception));
        }
        return false;
    }

    public boolean isBatchEngineTechnical(String zipEntryName) {
        return zipEntryName.endsWith(BatchEngineTaskContentType.JSONT.getFileExtension());
    }

    public URL transformURL(File file) throws AutoDeployException {
        try (ZipFile zipFile = new ZipFile(file);){
            this._deploy(zipFile);
        }
        catch (Exception exception) {
            throw new AutoDeployException((Throwable)exception);
        }
        return null;
    }

    public void uninstall(File file) {
    }

    private void _deploy(ZipFile zipFile) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deploying batch engine file " + zipFile.getName()));
        }
        this._batchEngineUnitProcessor.processBatchEngineUnits(this._getBatchEngineUnitsCollection(zipFile));
    }

    private BatchEngineUnitConfiguration _getBatchEngineUnitConfiguration(BatchEngineUnit batchEngineUnit) throws IOException {
        BatchEngineUnitConfiguration batchEngineUnitConfiguration = batchEngineUnit.getBatchEngineUnitConfiguration();
        if (batchEngineUnitConfiguration.getCompanyId() == 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Using default company ID for this batch process");
            }
            try {
                Company company = this._companyLocalService.getCompanyByWebId(PropsUtil.get((String)"company.default.web.id"));
                batchEngineUnitConfiguration.setCompanyId(company.getCompanyId());
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to get default company ID", (Throwable)portalException);
            }
        }
        if (batchEngineUnitConfiguration.getUserId() == 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Using default user ID for this batch process");
            }
            try {
                List users = this._userLocalService.getUsersByRoleName(batchEngineUnitConfiguration.getCompanyId(), "Administrator", 0, 1);
                User user = (User)users.get(0);
                batchEngineUnitConfiguration.setUserId(user.getUserId());
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to get default user ID", (Throwable)portalException);
            }
        }
        return batchEngineUnitConfiguration;
    }

    private Collection<BatchEngineUnit> _getBatchEngineUnitsCollection(ZipFile zipFile) {
        HashMap<String, ZipEntry> batchEngineZipEntries = new HashMap<String, ZipEntry>();
        TreeMap<String, Object> batchEngineUnits = new TreeMap<String, Object>((Comparator<String>)new NaturalOrderStringComparator());
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            String key = this._getBatchEngineZipEntryKey(zipEntry);
            ZipEntry complementZipEntry = (ZipEntry)batchEngineZipEntries.get(key);
            if (complementZipEntry == null) {
                batchEngineZipEntries.put(key, zipEntry);
                batchEngineUnits.put(key, new AdvancedZipBatchEngineUnitImpl(zipFile, zipEntry));
                continue;
            }
            batchEngineUnits.put(key, new ClassicZipBatchEngineUnitImpl(zipFile, zipEntry, complementZipEntry));
            batchEngineZipEntries.remove(key);
        }
        return batchEngineUnits.values();
    }

    private String _getBatchEngineZipEntryKey(ZipEntry zipEntry) {
        String zipEntryName = zipEntry.getName();
        if (this.isBatchEngineTechnical(zipEntryName)) {
            return zipEntryName;
        }
        if (!zipEntryName.contains("/")) {
            return "";
        }
        return zipEntryName.substring(0, zipEntryName.lastIndexOf("/"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _isClientExtension(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!Objects.equals(name, "WEB-INF/liferay-plugin-package.properties") && (!name.endsWith(".client-extension-config.json") || name.indexOf(47) != -1)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to check if " + file + " is a client extension"), (Throwable)ioException);
            return false;
        }
    }
}

