/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.installer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassicZipBatchEngineUnitImpl
implements BatchEngineUnit {
    private ZipEntry _configurationZipEntry;
    private ZipEntry _dataZipEntry;
    private final ZipFile _zipFile;

    public ClassicZipBatchEngineUnitImpl(ZipFile zipFile, ZipEntry ... zipEntries) {
        this._zipFile = zipFile;
        if (zipEntries == null || zipEntries.length > 2) {
            return;
        }
        for (ZipEntry zipEntry : zipEntries) {
            if (this._isBatchEngineConfiguration(zipEntry.getName())) {
                this._configurationZipEntry = zipEntry;
                continue;
            }
            this._dataZipEntry = zipEntry;
        }
    }

    public BatchEngineUnitConfiguration getBatchEngineUnitConfiguration() throws IOException {
        try (InputStream inputStream = this._zipFile.getInputStream(this._configurationZipEntry);){
            ObjectMapper objectMapper = new ObjectMapper();
            BatchEngineUnitConfiguration batchEngineUnitConfiguration = (BatchEngineUnitConfiguration)objectMapper.readValue(inputStream, BatchEngineUnitConfiguration.class);
            return batchEngineUnitConfiguration;
        }
    }

    public InputStream getConfigurationInputStream() throws IOException {
        return this._zipFile.getInputStream(this._configurationZipEntry);
    }

    public String getDataFileName() {
        return this._dataZipEntry.getName();
    }

    public InputStream getDataInputStream() throws IOException {
        return this._zipFile.getInputStream(this._dataZipEntry);
    }

    public String getFileName() {
        return this._zipFile.getName();
    }

    public boolean isValid() {
        return this._configurationZipEntry != null && this._dataZipEntry != null;
    }

    private boolean _isBatchEngineConfiguration(String zipEntryName) {
        return Objects.equals(zipEntryName, "batch-engine.json") || zipEntryName.endsWith("/batch-engine.json");
    }
}

