/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineDeletionHelper;
import com.liferay.batch.engine.internal.exportimport.data.handler.BatchEnginePortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={BatchEngineDeletionHelper.class})
public class BatchEngineDeletionHelperImpl
implements BatchEngineDeletionHelper {
    private ServiceTrackerMap<String, PortletDataHandler> _portletIdServiceTrackerMap;
    private ServiceTrackerMap<String, PortletDataHandler> _serviceTrackerMap;

    public void addDeletionEvent(PortletDataContext portletDataContext, SystemEvent systemEvent) {
        Map newPrimaryKeysMap = portletDataContext.getNewPrimaryKeysMap(systemEvent.getClassName() + "_batchDeleteExternalReferenceCodes");
        newPrimaryKeysMap.put(systemEvent.getClassExternalReferenceCode(), "");
    }

    public void exportDeletions(PortletDataContext portletDataContext) {
        Map newPrimaryKeysMaps = portletDataContext.getNewPrimaryKeysMaps();
        for (String key : newPrimaryKeysMaps.keySet()) {
            BatchEnginePortletDataHandler batchEnginePortletDataHandler;
            if (!key.endsWith("_batchDeleteExternalReferenceCodes") || (batchEnginePortletDataHandler = this._getBatchEnginePortletDataHandler(StringUtil.removeLast((String)key, (String)"_batchDeleteExternalReferenceCodes"))) == null) continue;
            batchEnginePortletDataHandler.exportDeletionSystemEvents(portletDataContext);
        }
    }

    public void importDeletions(PortletDataContext portletDataContext, String portletId) throws Exception {
        PortletDataHandler portletDataHandler = this._getPortletDataHandlerForPortlet(portletId);
        if (portletDataHandler != null) {
            portletDataHandler.deleteData(portletDataContext, portletId, null);
        }
    }

    public boolean isBatchDeleteSupported(String className) {
        return this._serviceTrackerMap.containsKey((Object)className);
    }

    public boolean isBatchPortlet(String portletId) {
        PortletDataHandler portletDataHandler = (PortletDataHandler)this._portletIdServiceTrackerMap.getService((Object)portletId);
        return portletDataHandler instanceof BatchEnginePortletDataHandler;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._portletIdServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PortletDataHandler.class, (String)"javax.portlet.name");
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PortletDataHandler.class, (String)"batch.engine.task.item.delegate.item.class.name");
    }

    @Deactivate
    protected void deactivate() {
        this._portletIdServiceTrackerMap.close();
        this._serviceTrackerMap.close();
    }

    private BatchEnginePortletDataHandler _getBatchEnginePortletDataHandler(String className) {
        PortletDataHandler portletDataHandler = (PortletDataHandler)this._serviceTrackerMap.getService((Object)className);
        if (portletDataHandler instanceof BatchEnginePortletDataHandler) {
            return (BatchEnginePortletDataHandler)portletDataHandler;
        }
        return null;
    }

    private PortletDataHandler _getPortletDataHandlerForPortlet(String portletId) {
        PortletDataHandler portletDataHandler = (PortletDataHandler)this._portletIdServiceTrackerMap.getService((Object)portletId);
        if (portletDataHandler instanceof BatchEnginePortletDataHandler) {
            return portletDataHandler;
        }
        return null;
    }
}

