/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.problem.Problem;
import com.liferay.portal.vulcan.problem.ProblemProvider;
import java.util.Locale;

public class ErrorMessageUtil {
    private static final Log _log = LogFactoryUtil.getLog(ErrorMessageUtil.class);
    private static final Snapshot<ProblemProvider> _problemProviderRegistrySnapshot = new Snapshot(ErrorMessageUtil.class, ProblemProvider.class);

    public static String getErrorMessage(Throwable throwable, long userId) {
        if (throwable == null) {
            return null;
        }
        ProblemProvider problemProvider = (ProblemProvider)_problemProviderRegistrySnapshot.get();
        Problem problem = problemProvider.getProblem(throwable);
        if (problem != null) {
            return problem.getDetail(ErrorMessageUtil._getLocale(userId));
        }
        return throwable.toString();
    }

    private static Locale _getLocale(long userId) {
        try {
            User user = UserLocalServiceUtil.getUser((long)userId);
            return user.getLocale();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return LocaleUtil.getDefault();
        }
    }
}

