/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.unit;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.feature.flag.FeatureFlagListener;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={FeatureFlagBatchEngineUnitProcessor.class})
public class FeatureFlagBatchEngineUnitProcessor {
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    private ServiceRegistration<FeatureFlagListener> _serviceRegistration;
    private final Map<Tuple, List<UnsafeSupplier<CompletableFuture<Void>, Exception>>> _unsafeSuppliers = new ConcurrentHashMap<Tuple, List<UnsafeSupplier<CompletableFuture<Void>, Exception>>>();

    public void registerBatchEngineUnit(long companyId, String featureFlagKey, UnsafeSupplier<CompletableFuture<Void>, Exception> unsafeSupplier) {
        this._unsafeSuppliers.compute(this._getTuple(companyId, featureFlagKey), (key, unsafeSuppliers) -> {
            if (unsafeSuppliers == null) {
                unsafeSuppliers = new ArrayList<UnsafeSupplier>();
            }
            unsafeSuppliers.add(unsafeSupplier);
            return unsafeSuppliers;
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(FeatureFlagListener.class, (Object)new FeatureFlagListenerImpl(), MapUtil.singletonDictionary((Object)"featureFlagKey", (Object)"*"));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private Tuple _getTuple(long companyId, String featureFlagKey) {
        return new Tuple(new Object[]{companyId, featureFlagKey});
    }

    private class FeatureFlagListenerImpl
    implements FeatureFlagListener {
        private FeatureFlagListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onValue(long companyId, String featureFlagKey, boolean enabled) {
            if (!enabled) {
                return;
            }
            Tuple tuple = FeatureFlagBatchEngineUnitProcessor.this._getTuple(companyId, featureFlagKey);
            if (!FeatureFlagBatchEngineUnitProcessor.this._unsafeSuppliers.containsKey(tuple)) {
                return;
            }
            Map map = FeatureFlagBatchEngineUnitProcessor.this._unsafeSuppliers;
            synchronized (map) {
                List unsafeSuppliers = (List)FeatureFlagBatchEngineUnitProcessor.this._unsafeSuppliers.remove(tuple);
                NoticeableExecutorService executorService = FeatureFlagBatchEngineUnitProcessor.this._portalExecutorManager.getPortalExecutor(FeatureFlagListenerImpl.class.getName());
                executorService.submit(() -> {
                    for (UnsafeSupplier unsafeSupplier : unsafeSuppliers) {
                        try {
                            CompletableFuture completableFuture = (CompletableFuture)unsafeSupplier.get();
                            completableFuture.get();
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                });
            }
        }
    }
}

