/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.installer;

import com.liferay.batch.engine.internal.json.AdvancedJSONReader;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AdvancedZipBatchEngineUnitImpl
implements BatchEngineUnit {
    private static final Log _log = LogFactoryUtil.getLog(AdvancedZipBatchEngineUnitImpl.class);
    private final ZipEntry _zipEntry;
    private final ZipFile _zipFile;

    public AdvancedZipBatchEngineUnitImpl(ZipFile zipFile, ZipEntry zipEntry) {
        this._zipFile = zipFile;
        this._zipEntry = zipEntry;
    }

    public BatchEngineUnitConfiguration getBatchEngineUnitConfiguration() throws IOException {
        try (InputStream inputStream = this._zipFile.getInputStream(this._zipEntry);){
            AdvancedJSONReader<BatchEngineUnitConfiguration> advancedJSONReader = new AdvancedJSONReader<BatchEngineUnitConfiguration>(inputStream);
            BatchEngineUnitConfiguration batchEngineUnitConfiguration = advancedJSONReader.getObject("configuration", BatchEngineUnitConfiguration.class);
            return batchEngineUnitConfiguration;
        }
    }

    public InputStream getConfigurationInputStream() {
        throw new UnsupportedOperationException();
    }

    public String getDataFileName() {
        return this._zipEntry.getName();
    }

    public InputStream getDataInputStream() throws IOException {
        try (InputStream inputStream = this._zipFile.getInputStream(this._zipEntry);){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(inputStream);
            advancedJSONReader.transferJSONArray("items", byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    public String getFileName() {
        return this._zipFile.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid() {
        if (this._zipEntry == null) {
            return false;
        }
        try (InputStream inputStream = this._zipFile.getInputStream(this._zipEntry);){
            AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(inputStream);
            boolean bl = advancedJSONReader.hasKey("items");
            return bl;
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to get data in file " + this._zipEntry.getName()), (Throwable)ioException);
            return false;
        }
    }
}

