/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskItemDelegateRegistry;
import com.liferay.batch.engine.ItemClassRegistry;
import com.liferay.batch.engine.configuration.BatchEngineTaskCompanyConfiguration;
import com.liferay.batch.engine.csv.ColumnDescriptorProvider;
import com.liferay.batch.engine.internal.BatchEngineTaskCallbackUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskExecutorUtil;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutor;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutorFactory;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriterBuilder;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.pagination.Page;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BatchEngineExportTaskExecutor.class})
public class BatchEngineExportTaskExecutorImpl
implements BatchEngineExportTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineExportTaskExecutorImpl.class);
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    private BatchEngineTaskItemDelegateExecutorFactory _batchEngineTaskItemDelegateExecutorFactory;
    @Reference
    private BatchEngineTaskItemDelegateRegistry _batchEngineTaskItemDelegateRegistry;
    @Reference
    private ColumnDescriptorProvider _columnDescriptorProvider;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private ItemClassRegistry _itemClassRegistry;
    @Reference
    private SortParserProvider _sortParserProvider;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(BatchEngineExportTask batchEngineExportTask) {
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)batchEngineExportTask.getCompanyId(), (Long)CTCollectionThreadLocal.getCTCollectionId());){
            batchEngineExportTask.setExecuteStatus(BatchEngineTaskExecuteStatus.STARTED.toString());
            batchEngineExportTask.setStartTime(new Date());
            this._batchEngineExportTaskLocalService.updateBatchEngineExportTask(batchEngineExportTask);
            BatchEngineTaskExecutorUtil.execute(true, (UnsafeRunnable<Throwable>)((UnsafeRunnable)() -> this._exportItems(batchEngineExportTask)), this._userLocalService.getUser(batchEngineExportTask.getUserId()));
            this._updateBatchEngineExportTask(BatchEngineTaskExecuteStatus.COMPLETED, batchEngineExportTask, null);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._batchEngineTaskItemDelegateExecutorFactory = new BatchEngineTaskItemDelegateExecutorFactory(this._batchEngineTaskItemDelegateRegistry, this._expressionConvert, this._filterParserProvider, this._sortParserProvider);
    }

    private void _exportItems(BatchEngineExportTask batchEngineExportTask) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        Map<String, Serializable> parameters = this._getParameters(batchEngineExportTask);
        try (BatchEngineExportTaskItemWriter batchEngineExportTaskItemWriter = this._getBatchEngineExportTaskItemWriter(batchEngineExportTask, parameters, unsyncByteArrayOutputStream);){
            int exportBatchSize = this._getExportBatchSize(batchEngineExportTask.getCompanyId());
            BatchEngineTaskItemDelegateExecutor batchEngineTaskItemDelegateExecutor = this._batchEngineTaskItemDelegateExecutorFactory.create(batchEngineExportTask.getTaskItemDelegateName(), batchEngineExportTask.getClassName(), this._companyLocalService.getCompany(batchEngineExportTask.getCompanyId()), parameters, this._userLocalService.getUser(batchEngineExportTask.getUserId()));
            Page<?> page = batchEngineTaskItemDelegateExecutor.getItems(1, exportBatchSize);
            batchEngineExportTask.setTotalItemsCount(Math.toIntExact(page.getTotalCount()));
            Collection items = page.getItems();
            while (!items.isEmpty()) {
                batchEngineExportTaskItemWriter.write(items);
                batchEngineExportTask.setProcessedItemsCount(batchEngineExportTask.getProcessedItemsCount() + items.size());
                batchEngineExportTask = this._batchEngineExportTaskLocalService.updateBatchEngineExportTask(batchEngineExportTask);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!page.hasNext()) {
                    break;
                }
                page = batchEngineTaskItemDelegateExecutor.getItems((int)page.getPage() + 1, exportBatchSize);
                items = page.getItems();
            }
        }
        byte[] content = unsyncByteArrayOutputStream.toByteArray();
        batchEngineExportTask.setContent((Blob)new OutputBlob((InputStream)new UnsyncByteArrayInputStream(content), (long)content.length));
        this._batchEngineExportTaskLocalService.updateBatchEngineExportTask(batchEngineExportTask);
    }

    private BatchEngineExportTaskItemWriter _getBatchEngineExportTaskItemWriter(BatchEngineExportTask batchEngineExportTask, Map<String, Serializable> parameters, UnsyncByteArrayOutputStream unsyncByteArrayOutputStream) throws Exception {
        BatchEngineExportTaskItemWriterBuilder batchEngineExportTaskItemWriterBuilder = new BatchEngineExportTaskItemWriterBuilder();
        BatchEngineTaskContentType batchEngineTaskContentType = BatchEngineTaskContentType.valueOf((String)batchEngineExportTask.getContentType());
        return batchEngineExportTaskItemWriterBuilder.batchEngineTaskContentType(batchEngineTaskContentType).columnDescriptorProvider(this._columnDescriptorProvider).companyId(batchEngineExportTask.getCompanyId()).csvFileColumnDelimiter(GetterUtil.getString((String)this._getCSVFileColumnDelimiter(batchEngineExportTask.getCompanyId()), (String)",")).fieldNames(batchEngineExportTask.getFieldNamesList()).itemClass(this._itemClassRegistry.getItemClass(batchEngineExportTask.getClassName())).outputStream(this._getZipOutputStream(batchEngineTaskContentType, unsyncByteArrayOutputStream)).parameters(parameters).taskItemDelegateName(batchEngineExportTask.getTaskItemDelegateName()).userId(batchEngineExportTask.getUserId()).build();
    }

    private String _getCSVFileColumnDelimiter(long companyId) throws Exception {
        BatchEngineTaskCompanyConfiguration batchEngineTaskCompanyConfiguration = (BatchEngineTaskCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(BatchEngineTaskCompanyConfiguration.class, companyId);
        return batchEngineTaskCompanyConfiguration.csvFileColumnDelimiter();
    }

    private int _getExportBatchSize(long companyId) throws ConfigurationException {
        BatchEngineTaskCompanyConfiguration batchEngineTaskCompanyConfiguration = (BatchEngineTaskCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(BatchEngineTaskCompanyConfiguration.class, companyId);
        return batchEngineTaskCompanyConfiguration.exportBatchSize();
    }

    private Map<String, Serializable> _getParameters(BatchEngineExportTask batchEngineExportTask) {
        HashMap parameters = batchEngineExportTask.getParameters();
        if (parameters == null) {
            parameters = new HashMap();
        }
        return parameters;
    }

    private ZipOutputStream _getZipOutputStream(BatchEngineTaskContentType batchEngineTaskContentType, UnsyncByteArrayOutputStream unsyncByteArrayOutputStream) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)unsyncByteArrayOutputStream);
        ZipEntry zipEntry = new ZipEntry("export." + batchEngineTaskContentType.getFileExtension());
        zipOutputStream.putNextEntry(zipEntry);
        return zipOutputStream;
    }

    private void _updateBatchEngineExportTask(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, BatchEngineExportTask batchEngineExportTask, String errorMessage) {
        batchEngineExportTask.setEndTime(new Date());
        batchEngineExportTask.setErrorMessage(errorMessage);
        batchEngineExportTask.setExecuteStatus(batchEngineTaskExecuteStatus.toString());
        batchEngineExportTask = this._batchEngineExportTaskLocalService.updateBatchEngineExportTask(batchEngineExportTask);
        BatchEngineTaskCallbackUtil.sendCallback(batchEngineExportTask.getCallbackURL(), batchEngineExportTask.getExecuteStatus(), batchEngineExportTask.getBatchEngineExportTaskId());
    }
}

