/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.service.impl;

import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.service.base.BatchEngineExportTaskServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"json.web.service.context.name=batchengine", "json.web.service.context.path=BatchEngineExportTask"}, service={AopService.class})
public class BatchEngineExportTaskServiceImpl
extends BatchEngineExportTaskServiceBaseImpl {
    public BatchEngineExportTask addBatchEngineExportTask(String externalReferenceCode, long companyId, long userId, String callbackURL, String className, String contentType, String executeStatus, List<String> fieldNamesList, Map<String, Serializable> parameters, String taskItemDelegateName) throws PortalException {
        this._checkPermission(companyId);
        return this.batchEngineExportTaskLocalService.addBatchEngineExportTask(externalReferenceCode, companyId, userId, callbackURL, className, contentType, executeStatus, fieldNamesList, parameters, taskItemDelegateName);
    }

    public BatchEngineExportTask getBatchEngineExportTask(long batchEngineExportTaskId) throws PortalException {
        BatchEngineExportTask batchEngineExportTask = this.batchEngineExportTaskLocalService.getBatchEngineExportTask(batchEngineExportTaskId);
        this._checkPermission(batchEngineExportTask);
        return batchEngineExportTask;
    }

    public BatchEngineExportTask getBatchEngineExportTaskByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        this._checkPermission(companyId);
        BatchEngineExportTask batchEngineExportTask = this.batchEngineExportTaskLocalService.getBatchEngineExportTaskByExternalReferenceCode(externalReferenceCode, companyId);
        this._checkPermission(batchEngineExportTask);
        return batchEngineExportTask;
    }

    public List<BatchEngineExportTask> getBatchEngineExportTasks(long companyId, int start, int end) throws PortalException {
        this._checkPermission(companyId);
        return this._filterBatchEngineExportTasks(this.batchEngineExportTaskLocalService.getBatchEngineExportTasks(companyId, start, end));
    }

    public List<BatchEngineExportTask> getBatchEngineExportTasks(long companyId, int start, int end, OrderByComparator<BatchEngineExportTask> orderByComparator) throws PortalException {
        this._checkPermission(companyId);
        return this._filterBatchEngineExportTasks(this.batchEngineExportTaskLocalService.getBatchEngineExportTasks(companyId, start, end, orderByComparator));
    }

    public int getBatchEngineExportTasksCount(long companyId) throws PortalException {
        this._checkPermission(companyId);
        List<BatchEngineExportTask> filteredBatchEngineExportTasks = this._filterBatchEngineExportTasks(this.batchEngineExportTaskLocalService.getBatchEngineExportTasks(companyId, -1, -1));
        return filteredBatchEngineExportTasks.size();
    }

    public InputStream openContentInputStream(long batchEngineExportTaskId) throws PortalException {
        this._checkPermission(this.batchEngineExportTaskLocalService.getBatchEngineExportTask(batchEngineExportTaskId));
        return this.batchEngineExportTaskLocalService.openContentInputStream(batchEngineExportTaskId);
    }

    private void _checkPermission(BatchEngineExportTask batchEngineExportTask) throws PrincipalException {
        if (!this._hasPermission(batchEngineExportTask, this.getPermissionChecker())) {
            throw new PrincipalException();
        }
    }

    private void _checkPermission(long companyId) throws PrincipalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (companyId != permissionChecker.getCompanyId() && !permissionChecker.isOmniadmin()) {
            throw new PrincipalException();
        }
    }

    private List<BatchEngineExportTask> _filterBatchEngineExportTasks(List<BatchEngineExportTask> batchEngineExportTasks) throws PrincipalException {
        ArrayList<BatchEngineExportTask> filteredBatchEngineExportTasks = new ArrayList<BatchEngineExportTask>();
        PermissionChecker permissionChecker = this.getPermissionChecker();
        for (BatchEngineExportTask batchEngineExportTask : batchEngineExportTasks) {
            if (!this._hasPermission(batchEngineExportTask, permissionChecker)) continue;
            filteredBatchEngineExportTasks.add(batchEngineExportTask);
        }
        return filteredBatchEngineExportTasks;
    }

    private boolean _hasPermission(BatchEngineExportTask batchEngineExportTask, PermissionChecker permissionChecker) {
        return permissionChecker.isCompanyAdmin(batchEngineExportTask.getCompanyId()) || batchEngineExportTask.getUserId() == permissionChecker.getUserId();
    }
}

