/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.ColumnValuesExtractor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CSVBatchEngineExportTaskItemWriterImpl
implements BatchEngineExportTaskItemWriter {
    private final ColumnValuesExtractor _columnValuesExtractor;
    private final CSVPrinter _csvPrinter;

    public CSVBatchEngineExportTaskItemWriterImpl(String delimiter, Map<String, ObjectValuePair<Field, Method>> fieldNameObjectValuePairs, List<String> fieldNames, OutputStream outputStream, Map<String, Serializable> parameters) throws IOException {
        if (fieldNames.isEmpty()) {
            throw new IllegalArgumentException("Field names are not set");
        }
        this._csvPrinter = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter(outputStream)), this._getCSVFormat(delimiter));
        fieldNames = ListUtil.sort(fieldNames, (value1, value2) -> value1.compareToIgnoreCase((String)value2));
        this._columnValuesExtractor = new ColumnValuesExtractor(fieldNameObjectValuePairs, fieldNames);
        if (Boolean.valueOf((String)((Object)parameters.getOrDefault("containsHeaders", (Serializable)((Object)"true")))).booleanValue()) {
            this._csvPrinter.printRecord((Object[])this._columnValuesExtractor.getHeaders());
        }
    }

    @Override
    public void close() throws IOException {
        this._csvPrinter.close();
    }

    @Override
    public void write(Collection<?> items) throws Exception {
        ISO8601DateFormat dateFormat = new ISO8601DateFormat();
        for (Object item : items) {
            for (Object[] values : this._columnValuesExtractor.extractValues(item)) {
                this._write((DateFormat)dateFormat, values);
            }
        }
    }

    private CSVFormat _getCSVFormat(String delimiter) {
        CSVFormat.Builder builder = CSVFormat.Builder.create();
        builder.setDelimiter(delimiter);
        return builder.build();
    }

    private void _write(DateFormat dateFormat, Object[] values) throws Exception {
        for (Object value : values) {
            if (value instanceof Date) {
                value = dateFormat.format((Date)value);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                StringBundler sb = new StringBundler();
                for (Map.Entry entry : map.entrySet()) {
                    sb.append((String)entry.getKey());
                    sb.append(":");
                    sb.append(entry.getValue());
                    sb.append("\r\n");
                }
                value = sb.toString();
            }
            this._csvPrinter.print(value);
        }
        this._csvPrinter.println();
    }
}

