/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSBatchEngineImportTaskItemReaderImpl
implements BatchEngineImportTaskItemReader {
    private final String[] _fieldNames;
    private final InputStream _inputStream;
    private final Iterator<Row> _iterator;
    private final Workbook _workbook;

    public XLSBatchEngineImportTaskItemReaderImpl(InputStream inputStream) throws IOException {
        this._inputStream = inputStream;
        this._workbook = new XSSFWorkbook(this._inputStream);
        Sheet sheet = this._workbook.getSheetAt(0);
        this._iterator = sheet.rowIterator();
        Row row = this._iterator.next();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Cell cell : row) {
            columnNames.add(cell.getStringCellValue());
        }
        this._fieldNames = columnNames.toArray(new String[0]);
    }

    @Override
    public void close() throws IOException {
        this._inputStream.close();
        this._workbook.close();
    }

    @Override
    public Map<String, Object> read() throws Exception {
        if (!this._iterator.hasNext()) {
            return null;
        }
        Row row = this._iterator.next();
        HashMap<String, Object> fieldNameValueMap = new HashMap<String, Object>();
        int index = 0;
        for (Cell cell : row) {
            int lastDelimiterIndex;
            String fieldName;
            if ((fieldName = this._fieldNames[index++]) == null) continue;
            if (CellType.BOOLEAN == cell.getCellType()) {
                fieldNameValueMap.put(fieldName, cell.getBooleanCellValue());
                continue;
            }
            if (CellType.NUMERIC == cell.getCellType()) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    fieldNameValueMap.put(fieldName, cell.getDateCellValue());
                    continue;
                }
                fieldNameValueMap.put(fieldName, cell.getNumericCellValue());
                continue;
            }
            String value = cell.getStringCellValue();
            if ((value = value.trim()).isEmpty()) {
                value = null;
            }
            if ((lastDelimiterIndex = fieldName.lastIndexOf(95)) == -1) {
                fieldNameValueMap.put(fieldName, value);
                continue;
            }
            BatchEngineImportTaskItemReaderUtil.handleMapField(fieldName, fieldNameValueMap, lastDelimiterIndex, value);
        }
        return fieldNameValueMap;
    }
}

