/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.internal.upgrade.v4_0_1;

import com.liferay.batch.engine.internal.upgrade.v4_0_1.util.BatchEngineExportTaskTable;
import com.liferay.batch.engine.internal.upgrade.v4_0_1.util.BatchEngineImportTaskTable;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author Riccardo Ferrari
 */
public class ClassNameUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		if (hasColumnType(
				getTableName(BatchEngineExportTaskTable.class), "className",
				"VARCHAR(75) null")) {

			alter(
				BatchEngineExportTaskTable.class,
				new AlterColumnType("className", "VARCHAR(255) null"));
		}

		if (hasColumnType(
				getTableName(BatchEngineImportTaskTable.class), "className",
				"VARCHAR(75) null")) {

			alter(
				BatchEngineImportTaskTable.class,
				new AlterColumnType("className", "VARCHAR(255) null"));
		}
	}

}