/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.internal.task.progress;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author Matija Petanjek
 */
public class BatchEngineTaskProgressFactory {

	public BatchEngineTaskProgress create(
		BatchEngineTaskContentType batchEngineTaskContentType) {

		if (batchEngineTaskContentType == BatchEngineTaskContentType.JSON) {
			return new JSONBatchEngineTaskProgressImpl();
		}

		if (batchEngineTaskContentType == BatchEngineTaskContentType.JSONL) {
			return new JSONLBatchEngineTaskProgressImpl();
		}

		return new DefaultBatchEngineTaskProgressImpl();
	}

	private static final Log _log = LogFactoryUtil.getLog(
		BatchEngineTaskProgressFactory.class);

	private class DefaultBatchEngineTaskProgressImpl
		implements BatchEngineTaskProgress {

		@Override
		public int getTotalItemsCount(InputStream inputStream) {
			try {
				return 0;
			}
			finally {
				try {
					inputStream.close();
				}
				catch (IOException ioException) {
					_log.error("Unable to close input stream", ioException);
				}
			}
		}

	}

}