/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.ItemClassRegistry;
import com.liferay.batch.engine.internal.BatchEngineTaskMethodRegistry;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutor;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutorCreator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.filter.ExpressionConvert;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={BatchEngineTaskMethodRegistry.class, ItemClassRegistry.class})
public class BatchEngineTaskMethodRegistryImpl
implements BatchEngineTaskMethodRegistry {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineTaskMethodRegistryImpl.class);
    private final Map<Class<?>, Map<String, BatchEngineTaskItemDelegateExecutorCreator>> _batchEngineTaskItemDelegateExecutorCreators = new ConcurrentHashMap();
    private final Map<String, Class<?>> _itemClasses = new ConcurrentHashMap();
    private ServiceTracker<BatchEngineTaskItemDelegate<Object>, Class<?>> _serviceTracker;

    @Override
    public BatchEngineTaskItemDelegateExecutorCreator getBatchEngineTaskItemDelegateExecutorCreator(String itemClassName, String taskItemDelegateName) {
        if (Validator.isNull((String)taskItemDelegateName)) {
            taskItemDelegateName = "DEFAULT";
        }
        Map<String, BatchEngineTaskItemDelegateExecutorCreator> batchEngineTaskItemDelegateExecutorCreatorMap = this._batchEngineTaskItemDelegateExecutorCreators.get(this._itemClasses.get(itemClassName));
        return batchEngineTaskItemDelegateExecutorCreatorMap.get(taskItemDelegateName);
    }

    public Class<?> getItemClass(String itemClassName) {
        Class<?> itemClass = this._itemClasses.get(itemClassName);
        if (itemClass == null) {
            throw new IllegalStateException("Unknown class: " + itemClassName);
        }
        return itemClass;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTracker = new ServiceTracker(bundleContext, BatchEngineTaskItemDelegate.class.getName(), (ServiceTrackerCustomizer)new BatchEngineTaskMethodServiceTrackerCustomizer(bundleContext));
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class BatchEngineTaskMethodServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<BatchEngineTaskItemDelegate<Object>, Class<?>> {
        private final BundleContext _bundleContext;

        public Class<?> addingService(ServiceReference<BatchEngineTaskItemDelegate<Object>> serviceReference) {
            String batchEngineTaskItemDelegateName;
            BatchEngineTaskItemDelegate batchEngineTaskItemDelegate = (BatchEngineTaskItemDelegate)this._bundleContext.getService(serviceReference);
            Class<?> itemClass = this._getItemClass(batchEngineTaskItemDelegate);
            Map batchEngineTaskItemDelegateExecutorCreatorMap = BatchEngineTaskMethodRegistryImpl.this._batchEngineTaskItemDelegateExecutorCreators.computeIfAbsent(itemClass, key -> new ConcurrentHashMap());
            if (batchEngineTaskItemDelegateExecutorCreatorMap.containsKey(batchEngineTaskItemDelegateName = this._getBatchEngineTaskItemDelegateName(serviceReference))) {
                throw new IllegalStateException(batchEngineTaskItemDelegateName + " is already registered");
            }
            ServiceObjects serviceObjects = this._bundleContext.getServiceObjects(serviceReference);
            batchEngineTaskItemDelegateExecutorCreatorMap.put(batchEngineTaskItemDelegateName, (company, expressionConvert, filterParserProvider, parameters, sortParserProvider, user) -> new BatchEngineTaskItemDelegateExecutor(company, (ExpressionConvert<Filter>)expressionConvert, filterParserProvider, parameters, (ServiceObjects<BatchEngineTaskItemDelegate<Object>>)serviceObjects, sortParserProvider, user));
            BatchEngineTaskMethodRegistryImpl.this._itemClasses.put(itemClass.getName(), itemClass);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Batch engine task item delegate registered for item ", "class ", itemClass, " and delegate name ", batchEngineTaskItemDelegateName}));
            }
            return itemClass;
        }

        public void modifiedService(ServiceReference<BatchEngineTaskItemDelegate<Object>> serviceReference, Class<?> itemClass) {
        }

        public void removedService(ServiceReference<BatchEngineTaskItemDelegate<Object>> serviceReference, Class<?> itemClass) {
            Map batchEngineTaskItemDelegateExecutorCreatorMap = (Map)BatchEngineTaskMethodRegistryImpl.this._batchEngineTaskItemDelegateExecutorCreators.get(itemClass);
            String batchEngineTaskItemDelegateName = this._getBatchEngineTaskItemDelegateName(serviceReference);
            batchEngineTaskItemDelegateExecutorCreatorMap.remove(batchEngineTaskItemDelegateName);
            if (batchEngineTaskItemDelegateExecutorCreatorMap.isEmpty()) {
                BatchEngineTaskMethodRegistryImpl.this._batchEngineTaskItemDelegateExecutorCreators.remove(itemClass);
                BatchEngineTaskMethodRegistryImpl.this._itemClasses.remove(itemClass.getName());
            }
            this._bundleContext.ungetService(serviceReference);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Batch engine task item delegate unregistered for item class " + itemClass));
            }
        }

        private BatchEngineTaskMethodServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        private String _getBatchEngineTaskItemDelegateName(ServiceReference<BatchEngineTaskItemDelegate<Object>> serviceReference) {
            return GetterUtil.getString((Object)serviceReference.getProperty("batch.engine.task.item.delegate.name"), (String)"DEFAULT");
        }

        private Class<?> _getItemClass(BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate) {
            Class<?> itemClass = batchEngineTaskItemDelegate.getItemClass();
            if (itemClass != null) {
                return itemClass;
            }
            Class<?> batchEngineTaskItemDelegateClass = batchEngineTaskItemDelegate.getClass();
            itemClass = this._getItemClassFromGenericInterfaces(batchEngineTaskItemDelegateClass.getGenericInterfaces());
            if (itemClass == null) {
                itemClass = this._getItemClassFromGenericSuperclass(batchEngineTaskItemDelegateClass.getGenericSuperclass());
            }
            if (itemClass == null) {
                throw new IllegalStateException(BatchEngineTaskItemDelegate.class.getName() + " is not implemented");
            }
            return itemClass;
        }

        private Class<?> _getItemClass(ParameterizedType parameterizedType) {
            Type[] genericTypes = parameterizedType.getActualTypeArguments();
            return (Class)genericTypes[0];
        }

        private Class<?> _getItemClassFromGenericInterfaces(Type[] genericInterfaceTypes) {
            for (Type genericInterfaceType : genericInterfaceTypes) {
                ParameterizedType parameterizedType;
                if (!(genericInterfaceType instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)genericInterfaceType).getRawType() != BatchEngineTaskItemDelegate.class) continue;
                return this._getItemClass(parameterizedType);
            }
            return null;
        }

        private Class<?> _getItemClassFromGenericSuperclass(Type genericSuperclassType) {
            if (genericSuperclassType == null) {
                return null;
            }
            return this._getItemClass((ParameterizedType)genericSuperclassType);
        }
    }
}

