/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.engine.internal.upgrade;

import com.liferay.batch.engine.internal.upgrade.v4_0_0.UpgradeVersion;
import com.liferay.batch.engine.internal.upgrade.v4_0_1.UpgradeClassName;
import com.liferay.batch.engine.internal.upgrade.v4_1_0.UpgradeTaskItemDelegateName;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.upgrade.DummyUpgradeStep;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Ivica Cardic
 */
@Component(immediate = true, service = UpgradeStepRegistrator.class)
public class BatchEngineServiceUpgrade implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		registry.register("2.0.0", "3.0.0", new DummyUpgradeStep());

		registry.register("3.0.0", "4.0.0", new UpgradeVersion());

		registry.register("4.0.0", "4.0.1", new UpgradeClassName());

		registry.register("4.0.1", "4.1.0", new UpgradeTaskItemDelegateName());
	}

	@Reference(target = ModuleServiceLifecycle.PORTAL_INITIALIZED)
	private ModuleServiceLifecycle _moduleServiceLifecycle;

}