/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.app.builder.workflow.model.impl;

import com.liferay.app.builder.workflow.model.AppBuilderWorkflowTaskLink;
import com.liferay.app.builder.workflow.service.AppBuilderWorkflowTaskLinkLocalServiceUtil;

/**
 * The extended model base implementation for the AppBuilderWorkflowTaskLink service. Represents a row in the &quot;AppBuilderWorkflowTaskLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AppBuilderWorkflowTaskLinkImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AppBuilderWorkflowTaskLinkImpl
 * @see AppBuilderWorkflowTaskLink
 * @generated
 */
public abstract class AppBuilderWorkflowTaskLinkBaseImpl
	extends AppBuilderWorkflowTaskLinkModelImpl
	implements AppBuilderWorkflowTaskLink {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a app builder workflow task link model instance should use the <code>AppBuilderWorkflowTaskLink</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			AppBuilderWorkflowTaskLinkLocalServiceUtil.
				addAppBuilderWorkflowTaskLink(this);
		}
		else {
			AppBuilderWorkflowTaskLinkLocalServiceUtil.
				updateAppBuilderWorkflowTaskLink(this);
		}
	}

}