/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.app.builder.workflow.service.base;

import com.liferay.app.builder.workflow.model.AppBuilderWorkflowTaskLink;
import com.liferay.app.builder.workflow.service.AppBuilderWorkflowTaskLinkLocalService;
import com.liferay.app.builder.workflow.service.AppBuilderWorkflowTaskLinkLocalServiceUtil;
import com.liferay.app.builder.workflow.service.persistence.AppBuilderWorkflowTaskLinkPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;

import java.io.Serializable;

import java.lang.reflect.Field;

import java.util.List;

import javax.sql.DataSource;

import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the app builder workflow task link local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.app.builder.workflow.service.impl.AppBuilderWorkflowTaskLinkLocalServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.app.builder.workflow.service.impl.AppBuilderWorkflowTaskLinkLocalServiceImpl
 * @generated
 */
public abstract class AppBuilderWorkflowTaskLinkLocalServiceBaseImpl
	extends BaseLocalServiceImpl
	implements AopService, AppBuilderWorkflowTaskLinkLocalService,
			   IdentifiableOSGiService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>AppBuilderWorkflowTaskLinkLocalService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>AppBuilderWorkflowTaskLinkLocalServiceUtil</code>.
	 */

	/**
	 * Adds the app builder workflow task link to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect AppBuilderWorkflowTaskLinkLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param appBuilderWorkflowTaskLink the app builder workflow task link
	 * @return the app builder workflow task link that was added
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public AppBuilderWorkflowTaskLink addAppBuilderWorkflowTaskLink(
		AppBuilderWorkflowTaskLink appBuilderWorkflowTaskLink) {

		appBuilderWorkflowTaskLink.setNew(true);

		return appBuilderWorkflowTaskLinkPersistence.update(
			appBuilderWorkflowTaskLink);
	}

	/**
	 * Creates a new app builder workflow task link with the primary key. Does not add the app builder workflow task link to the database.
	 *
	 * @param appBuilderWorkflowTaskLinkId the primary key for the new app builder workflow task link
	 * @return the new app builder workflow task link
	 */
	@Override
	@Transactional(enabled = false)
	public AppBuilderWorkflowTaskLink createAppBuilderWorkflowTaskLink(
		long appBuilderWorkflowTaskLinkId) {

		return appBuilderWorkflowTaskLinkPersistence.create(
			appBuilderWorkflowTaskLinkId);
	}

	/**
	 * Deletes the app builder workflow task link with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect AppBuilderWorkflowTaskLinkLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param appBuilderWorkflowTaskLinkId the primary key of the app builder workflow task link
	 * @return the app builder workflow task link that was removed
	 * @throws PortalException if a app builder workflow task link with the primary key could not be found
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public AppBuilderWorkflowTaskLink deleteAppBuilderWorkflowTaskLink(
			long appBuilderWorkflowTaskLinkId)
		throws PortalException {

		return appBuilderWorkflowTaskLinkPersistence.remove(
			appBuilderWorkflowTaskLinkId);
	}

	/**
	 * Deletes the app builder workflow task link from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect AppBuilderWorkflowTaskLinkLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param appBuilderWorkflowTaskLink the app builder workflow task link
	 * @return the app builder workflow task link that was removed
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public AppBuilderWorkflowTaskLink deleteAppBuilderWorkflowTaskLink(
		AppBuilderWorkflowTaskLink appBuilderWorkflowTaskLink) {

		return appBuilderWorkflowTaskLinkPersistence.remove(
			appBuilderWorkflowTaskLink);
	}

	@Override
	public <T> T dslQuery(DSLQuery dslQuery) {
		return appBuilderWorkflowTaskLinkPersistence.dslQuery(dslQuery);
	}

	@Override
	public int dslQueryCount(DSLQuery dslQuery) {
		Long count = dslQuery(dslQuery);

		return count.intValue();
	}

	@Override
	public DynamicQuery dynamicQuery() {
		Class<?> clazz = getClass();

		return DynamicQueryFactoryUtil.forClass(
			AppBuilderWorkflowTaskLink.class, clazz.getClassLoader());
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
		return appBuilderWorkflowTaskLinkPersistence.findWithDynamicQuery(
			dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.app.builder.workflow.model.impl.AppBuilderWorkflowTaskLinkModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end) {

		return appBuilderWorkflowTaskLinkPersistence.findWithDynamicQuery(
			dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.app.builder.workflow.model.impl.AppBuilderWorkflowTaskLinkModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator<T> orderByComparator) {

		return appBuilderWorkflowTaskLinkPersistence.findWithDynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(DynamicQuery dynamicQuery) {
		return appBuilderWorkflowTaskLinkPersistence.countWithDynamicQuery(
			dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		DynamicQuery dynamicQuery, Projection projection) {

		return appBuilderWorkflowTaskLinkPersistence.countWithDynamicQuery(
			dynamicQuery, projection);
	}

	@Override
	public AppBuilderWorkflowTaskLink fetchAppBuilderWorkflowTaskLink(
		long appBuilderWorkflowTaskLinkId) {

		return appBuilderWorkflowTaskLinkPersistence.fetchByPrimaryKey(
			appBuilderWorkflowTaskLinkId);
	}

	/**
	 * Returns the app builder workflow task link with the primary key.
	 *
	 * @param appBuilderWorkflowTaskLinkId the primary key of the app builder workflow task link
	 * @return the app builder workflow task link
	 * @throws PortalException if a app builder workflow task link with the primary key could not be found
	 */
	@Override
	public AppBuilderWorkflowTaskLink getAppBuilderWorkflowTaskLink(
			long appBuilderWorkflowTaskLinkId)
		throws PortalException {

		return appBuilderWorkflowTaskLinkPersistence.findByPrimaryKey(
			appBuilderWorkflowTaskLinkId);
	}

	@Override
	public ActionableDynamicQuery getActionableDynamicQuery() {
		ActionableDynamicQuery actionableDynamicQuery =
			new DefaultActionableDynamicQuery();

		actionableDynamicQuery.setBaseLocalService(
			appBuilderWorkflowTaskLinkLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(AppBuilderWorkflowTaskLink.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName(
			"appBuilderWorkflowTaskLinkId");

		return actionableDynamicQuery;
	}

	@Override
	public IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		IndexableActionableDynamicQuery indexableActionableDynamicQuery =
			new IndexableActionableDynamicQuery();

		indexableActionableDynamicQuery.setBaseLocalService(
			appBuilderWorkflowTaskLinkLocalService);
		indexableActionableDynamicQuery.setClassLoader(getClassLoader());
		indexableActionableDynamicQuery.setModelClass(
			AppBuilderWorkflowTaskLink.class);

		indexableActionableDynamicQuery.setPrimaryKeyPropertyName(
			"appBuilderWorkflowTaskLinkId");

		return indexableActionableDynamicQuery;
	}

	protected void initActionableDynamicQuery(
		ActionableDynamicQuery actionableDynamicQuery) {

		actionableDynamicQuery.setBaseLocalService(
			appBuilderWorkflowTaskLinkLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(AppBuilderWorkflowTaskLink.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName(
			"appBuilderWorkflowTaskLinkId");
	}

	/**
	 * @throws PortalException
	 */
	public PersistedModel createPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return appBuilderWorkflowTaskLinkPersistence.create(
			((Long)primaryKeyObj).longValue());
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel deletePersistedModel(PersistedModel persistedModel)
		throws PortalException {

		return appBuilderWorkflowTaskLinkLocalService.
			deleteAppBuilderWorkflowTaskLink(
				(AppBuilderWorkflowTaskLink)persistedModel);
	}

	public BasePersistence<AppBuilderWorkflowTaskLink> getBasePersistence() {
		return appBuilderWorkflowTaskLinkPersistence;
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel getPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return appBuilderWorkflowTaskLinkPersistence.findByPrimaryKey(
			primaryKeyObj);
	}

	/**
	 * Returns a range of all the app builder workflow task links.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.app.builder.workflow.model.impl.AppBuilderWorkflowTaskLinkModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of app builder workflow task links
	 * @param end the upper bound of the range of app builder workflow task links (not inclusive)
	 * @return the range of app builder workflow task links
	 */
	@Override
	public List<AppBuilderWorkflowTaskLink> getAppBuilderWorkflowTaskLinks(
		int start, int end) {

		return appBuilderWorkflowTaskLinkPersistence.findAll(start, end);
	}

	/**
	 * Returns the number of app builder workflow task links.
	 *
	 * @return the number of app builder workflow task links
	 */
	@Override
	public int getAppBuilderWorkflowTaskLinksCount() {
		return appBuilderWorkflowTaskLinkPersistence.countAll();
	}

	/**
	 * Updates the app builder workflow task link in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect AppBuilderWorkflowTaskLinkLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param appBuilderWorkflowTaskLink the app builder workflow task link
	 * @return the app builder workflow task link that was updated
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public AppBuilderWorkflowTaskLink updateAppBuilderWorkflowTaskLink(
		AppBuilderWorkflowTaskLink appBuilderWorkflowTaskLink) {

		return appBuilderWorkflowTaskLinkPersistence.update(
			appBuilderWorkflowTaskLink);
	}

	@Deactivate
	protected void deactivate() {
		_setLocalServiceUtilService(null);
	}

	@Override
	public Class<?>[] getAopInterfaces() {
		return new Class<?>[] {
			AppBuilderWorkflowTaskLinkLocalService.class,
			IdentifiableOSGiService.class, PersistedModelLocalService.class
		};
	}

	@Override
	public void setAopProxy(Object aopProxy) {
		appBuilderWorkflowTaskLinkLocalService =
			(AppBuilderWorkflowTaskLinkLocalService)aopProxy;

		_setLocalServiceUtilService(appBuilderWorkflowTaskLinkLocalService);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return AppBuilderWorkflowTaskLinkLocalService.class.getName();
	}

	protected Class<?> getModelClass() {
		return AppBuilderWorkflowTaskLink.class;
	}

	protected String getModelClassName() {
		return AppBuilderWorkflowTaskLink.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		try {
			DataSource dataSource =
				appBuilderWorkflowTaskLinkPersistence.getDataSource();

			DB db = DBManagerUtil.getDB();

			sql = db.buildSQL(sql);
			sql = PortalUtil.transformSQL(sql);

			SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(
				dataSource, sql);

			sqlUpdate.update();
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	private void _setLocalServiceUtilService(
		AppBuilderWorkflowTaskLinkLocalService
			appBuilderWorkflowTaskLinkLocalService) {

		try {
			Field field =
				AppBuilderWorkflowTaskLinkLocalServiceUtil.class.
					getDeclaredField("_service");

			field.setAccessible(true);

			field.set(null, appBuilderWorkflowTaskLinkLocalService);
		}
		catch (ReflectiveOperationException reflectiveOperationException) {
			throw new RuntimeException(reflectiveOperationException);
		}
	}

	protected AppBuilderWorkflowTaskLinkLocalService
		appBuilderWorkflowTaskLinkLocalService;

	@Reference
	protected AppBuilderWorkflowTaskLinkPersistence
		appBuilderWorkflowTaskLinkPersistence;

	@Reference
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	private static final Log _log = LogFactoryUtil.getLog(
		AppBuilderWorkflowTaskLinkLocalServiceBaseImpl.class);

}