/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.internal.upgrade.v2_2_0;

import com.liferay.app.builder.internal.upgrade.v2_2_0.util.AppBuilderAppTable;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class UpgradeAppBuilderApp
extends UpgradeProcess {
    private final DDLRecordSetLocalService _ddlRecordSetLocalService;
    private final Map<Long, Long> _ddmStructureIdDDLRecordSetIdMap = new HashMap<Long, Long>();
    private final DDMStructureLocalService _ddmStructureLocalService;

    public UpgradeAppBuilderApp(DDLRecordSetLocalService ddlRecordSetLocalService, DDMStructureLocalService ddmStructureLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("AppBuilderApp", "ddlRecordSetId")) {
            this.alter(AppBuilderAppTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "ddlRecordSetId", "LONG")});
            try (PreparedStatement ps1 = this.connection.prepareStatement("select appBuilderAppId, ddmStructureId, groupId from AppBuilderApp");
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update AppBuilderApp set ddlRecordSetId = ? where appBuilderAppId = ?");
                 ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ps2.setLong(1, this._getDDLRecordSetId(rs.getLong("ddmStructureId"), rs.getLong("groupId")));
                    ps2.setLong(2, rs.getLong("appBuilderAppId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private long _getDDLRecordSetId(long ddmStructureId, long groupId) throws PortalException {
        if (this._ddmStructureIdDDLRecordSetIdMap.containsKey(ddmStructureId)) {
            return this._ddmStructureIdDDLRecordSetIdMap.get(ddmStructureId);
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(ddmStructureId);
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(groupId, ddmStructure.getStructureKey());
        this._ddmStructureIdDDLRecordSetIdMap.put(ddmStructureId, ddlRecordSet.getRecordSetId());
        return this._ddmStructureIdDDLRecordSetIdMap.get(ddmStructureId);
    }
}

