/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.app.builder.model.impl;

import com.liferay.app.builder.model.AppBuilderAppDataRecordLink;
import com.liferay.app.builder.service.AppBuilderAppDataRecordLinkLocalServiceUtil;

/**
 * The extended model base implementation for the AppBuilderAppDataRecordLink service. Represents a row in the &quot;AppBuilderAppDataRecordLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AppBuilderAppDataRecordLinkImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AppBuilderAppDataRecordLinkImpl
 * @see AppBuilderAppDataRecordLink
 * @generated
 */
public abstract class AppBuilderAppDataRecordLinkBaseImpl
	extends AppBuilderAppDataRecordLinkModelImpl
	implements AppBuilderAppDataRecordLink {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a app builder app data record link model instance should use the <code>AppBuilderAppDataRecordLink</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			AppBuilderAppDataRecordLinkLocalServiceUtil.
				addAppBuilderAppDataRecordLink(this);
		}
		else {
			AppBuilderAppDataRecordLinkLocalServiceUtil.
				updateAppBuilderAppDataRecordLink(this);
		}
	}

}