/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.app.builder.model.impl;

/**
 * The extended model implementation for the AppBuilderAppVersion service.
 * Represents a row in the &quot;AppBuilderAppVersion&quot; database table, with
 * each column mapped to a property of this class.
 *
 * <p>
 * Helper methods and all application logic should be put in this class.
 * Whenever methods are added, rerun ServiceBuilder to copy their definitions
 * into the <code>com.liferay.app.builder.model.AppBuilderAppVersion</code>
 * interface.
 * </p>
 *
 * @author Brian Wing Shun Chan
 */
public class AppBuilderAppVersionImpl extends AppBuilderAppVersionBaseImpl {

	/**
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this class directly. All methods that expect a app
	 * builder app version model instance should use the {@link
	 * com.liferay.app.builder.model.AppBuilderAppVersion} interface instead.
	 */
	public AppBuilderAppVersionImpl() {
	}

}