/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.app.builder.model.impl;

import com.liferay.app.builder.model.AppBuilderAppDeployment;
import com.liferay.app.builder.service.AppBuilderAppDeploymentLocalServiceUtil;

/**
 * The extended model base implementation for the AppBuilderAppDeployment service. Represents a row in the &quot;AppBuilderAppDeployment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AppBuilderAppDeploymentImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AppBuilderAppDeploymentImpl
 * @see AppBuilderAppDeployment
 * @generated
 */
public abstract class AppBuilderAppDeploymentBaseImpl
	extends AppBuilderAppDeploymentModelImpl
	implements AppBuilderAppDeployment {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a app builder app deployment model instance should use the <code>AppBuilderAppDeployment</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			AppBuilderAppDeploymentLocalServiceUtil.addAppBuilderAppDeployment(
				this);
		}
		else {
			AppBuilderAppDeploymentLocalServiceUtil.
				updateAppBuilderAppDeployment(this);
		}
	}

}