/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.internal.workflow;

import com.liferay.app.builder.model.AppBuilderApp;
import com.liferay.app.builder.model.AppBuilderAppDataRecordLink;
import com.liferay.app.builder.service.AppBuilderAppDataRecordLinkLocalService;
import com.liferay.app.builder.service.AppBuilderAppLocalService;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WorkflowHandler.class})
public class AppBuilderAppWorkflowHandler
extends BaseWorkflowHandler<DDLRecord> {
    private static final Log _log = LogFactoryUtil.getLog(AppBuilderAppWorkflowHandler.class);
    @Reference
    private AppBuilderAppDataRecordLinkLocalService _appBuilderAppDataRecordLinkLocalService;
    @Reference
    private AppBuilderAppLocalService _appBuilderAppLocalService;
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public String getClassName() {
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{AppBuilderApp.class.getName(), DDLRecord.class.getName()});
    }

    public String getTitle(long classPK, Locale locale) {
        try {
            AppBuilderApp appBuilderApp = this._getAppBuilderApp(this._ddlRecordLocalService.getDDLRecord(classPK));
            return appBuilderApp.getName(locale);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            return null;
        }
    }

    public String getType(Locale locale) {
        return ResourceActionsUtil.getModelResource((Locale)locale, (String)this.getClassName());
    }

    public String getURLEditWorkflowTask(long workflowTaskId, ServiceContext serviceContext) throws PortalException {
        return String.valueOf(serviceContext.getAttribute("url"));
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        AppBuilderApp appBuilderApp = this._getAppBuilderApp(this._ddlRecordLocalService.getRecord(classPK));
        return this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, appBuilderApp.getGroupId(), this.getClassName(), appBuilderApp.getAppBuilderAppId(), 0L);
    }

    public boolean isVisible() {
        return false;
    }

    public DDLRecord updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long ddlRecordId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        DDLRecord ddlRecord = this._ddlRecordLocalService.getRecord(ddlRecordId);
        DDLRecordVersion ddlRecordVersion = ddlRecord.getRecordVersion();
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        return this._ddlRecordLocalService.updateStatus(userId, ddlRecordVersion.getRecordVersionId(), status, serviceContext);
    }

    private AppBuilderApp _getAppBuilderApp(DDLRecord ddlRecord) throws PortalException {
        AppBuilderAppDataRecordLink appBuilderAppDataRecordLink = this._appBuilderAppDataRecordLinkLocalService.getDDLRecordAppBuilderAppDataRecordLink(ddlRecord.getRecordId());
        return this._appBuilderAppLocalService.getAppBuilderApp(appBuilderAppDataRecordLink.getAppBuilderAppId());
    }
}

