/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.service.impl;

import com.liferay.app.builder.model.AppBuilderApp;
import com.liferay.app.builder.model.AppBuilderAppDeployment;
import com.liferay.app.builder.service.AppBuilderAppDeploymentLocalService;
import com.liferay.app.builder.service.base.AppBuilderAppLocalServiceBaseImpl;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.app.builder.model.AppBuilderApp"}, service={AopService.class})
public class AppBuilderAppLocalServiceImpl
extends AppBuilderAppLocalServiceBaseImpl {
    @Reference
    private AppBuilderAppDeploymentLocalService _appBuilderAppDeploymentLocalService;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public AppBuilderApp addAppBuilderApp(long groupId, long companyId, long userId, boolean active, long ddlRecordSetId, long ddmStructureId, long ddmStructureLayoutId, long deDataListViewId, Map<Locale, String> nameMap, String scope) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        AppBuilderApp appBuilderApp = this.appBuilderAppPersistence.create(this.counterLocalService.increment());
        appBuilderApp.setGroupId(groupId);
        appBuilderApp.setCompanyId(companyId);
        appBuilderApp.setUserId(user.getUserId());
        appBuilderApp.setUserName(user.getFullName());
        appBuilderApp.setCreateDate(new Date());
        appBuilderApp.setModifiedDate(new Date());
        appBuilderApp.setActive(active);
        appBuilderApp.setDdlRecordSetId(ddlRecordSetId);
        appBuilderApp.setDdmStructureId(ddmStructureId);
        appBuilderApp.setDdmStructureLayoutId(ddmStructureLayoutId);
        appBuilderApp.setDeDataListViewId(deDataListViewId);
        appBuilderApp.setNameMap(nameMap);
        appBuilderApp.setScope(scope);
        return (AppBuilderApp)this.appBuilderAppPersistence.update((BaseModel)appBuilderApp);
    }

    @Deprecated
    public AppBuilderApp addAppBuilderApp(long groupId, long companyId, long userId, boolean active, long ddmStructureId, long ddmStructureLayoutId, long deDataListViewId, Map<Locale, String> nameMap) throws PortalException {
        return this.addAppBuilderApp(groupId, companyId, userId, active, ddmStructureId, ddmStructureLayoutId, deDataListViewId, nameMap, "standard");
    }

    public AppBuilderApp addAppBuilderApp(long groupId, long companyId, long userId, boolean active, long ddmStructureId, long ddmStructureLayoutId, long deDataListViewId, Map<Locale, String> nameMap, String scope) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(ddmStructureId);
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(groupId, ddmStructure.getStructureKey());
        return this.addAppBuilderApp(groupId, companyId, userId, active, ddlRecordSet.getRecordSetId(), ddmStructureId, ddmStructureLayoutId, deDataListViewId, nameMap, scope);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public AppBuilderApp deleteAppBuilderApp(long appBuilderAppId) throws PortalException {
        List appBuilderAppDeployments = this._appBuilderAppDeploymentLocalService.getAppBuilderAppDeployments(appBuilderAppId);
        for (AppBuilderAppDeployment appBuilderAppDeployment : appBuilderAppDeployments) {
            this._appBuilderAppDeploymentLocalService.deleteAppBuilderAppDeployment(appBuilderAppDeployment.getAppBuilderAppDeploymentId());
        }
        return this.appBuilderAppPersistence.remove(appBuilderAppId);
    }

    public void deleteAppBuilderApps(long ddmStructureId) throws PortalException {
        List<AppBuilderApp> appBuilderApps = this.getAppBuilderApps(ddmStructureId);
        for (AppBuilderApp appBuilderApp : appBuilderApps) {
            this.appBuilderAppLocalService.deleteAppBuilderApp(appBuilderApp.getAppBuilderAppId());
        }
    }

    public List<Long> getAppBuilderAppIds(boolean active, String type) {
        return this.appBuilderAppFinder.findByA_T(active, type);
    }

    public List<AppBuilderApp> getAppBuilderApps(long ddmStructureId) {
        return this.appBuilderAppPersistence.findByDDMStructureId(ddmStructureId);
    }

    public List<AppBuilderApp> getAppBuilderApps(long companyId, boolean active) {
        return this.appBuilderAppPersistence.findByC_A(companyId, active);
    }

    public List<AppBuilderApp> getAppBuilderApps(long companyId, boolean active, String scope) {
        return this.appBuilderAppPersistence.findByC_A_S(companyId, active, scope);
    }

    public List<AppBuilderApp> getAppBuilderApps(long groupId, int start, int end, OrderByComparator<AppBuilderApp> orderByComparator) {
        return this.appBuilderAppPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<AppBuilderApp> getAppBuilderApps(long groupId, long companyId, long ddmStructureId, int start, int end, OrderByComparator<AppBuilderApp> orderByComparator) {
        return this.appBuilderAppPersistence.findByG_C_D(groupId, companyId, ddmStructureId, start, end, orderByComparator);
    }

    public List<AppBuilderApp> getAppBuilderApps(long groupId, String scope, int start, int end, OrderByComparator<AppBuilderApp> orderByComparator) {
        return this.appBuilderAppPersistence.findByG_S(groupId, scope, start, end, orderByComparator);
    }

    public int getAppBuilderAppsCount(long groupId) {
        return this.appBuilderAppPersistence.countByGroupId(groupId);
    }

    public int getAppBuilderAppsCount(long groupId, long companyId, long ddmStructureId) {
        return this.appBuilderAppPersistence.countByG_C_D(groupId, companyId, ddmStructureId);
    }

    public int getAppBuilderAppsCount(long groupId, String scope) {
        return this.appBuilderAppPersistence.countByG_S(groupId, scope);
    }

    public List<AppBuilderApp> getCompanyAppBuilderApps(long companyId, int start, int end, OrderByComparator<AppBuilderApp> orderByComparator) {
        return this.appBuilderAppPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<AppBuilderApp> getCompanyAppBuilderApps(long companyId, String scope, int start, int end, OrderByComparator<AppBuilderApp> orderByComparator) {
        return this.appBuilderAppPersistence.findByC_S(companyId, scope, start, end, orderByComparator);
    }

    public int getCompanyAppBuilderAppsCount(long companyId) {
        return this.appBuilderAppPersistence.countByCompanyId(companyId);
    }

    public int getCompanyAppBuilderAppsCount(long companyId, String scope) {
        return this.appBuilderAppPersistence.countByC_S(companyId, scope);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AppBuilderApp updateAppBuilderApp(long userId, long appBuilderAppId, boolean active, long ddmStructureId, long ddmStructureLayoutId, long deDataListViewId, Map<Locale, String> nameMap) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        AppBuilderApp appBuilderApp = this.appBuilderAppPersistence.findByPrimaryKey(appBuilderAppId);
        appBuilderApp.setUserId(user.getUserId());
        appBuilderApp.setUserName(user.getFullName());
        appBuilderApp.setModifiedDate(new Date());
        appBuilderApp.setActive(active);
        appBuilderApp.setDdmStructureId(ddmStructureId);
        appBuilderApp.setDdmStructureLayoutId(ddmStructureLayoutId);
        appBuilderApp.setDeDataListViewId(deDataListViewId);
        appBuilderApp.setNameMap(nameMap);
        return (AppBuilderApp)this.appBuilderAppPersistence.update((BaseModel)appBuilderApp);
    }
}

