/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.service.impl;

import com.liferay.app.builder.model.AppBuilderApp;
import com.liferay.app.builder.model.AppBuilderAppDeployment;
import com.liferay.app.builder.service.AppBuilderAppDeploymentLocalService;
import com.liferay.app.builder.service.base.AppBuilderAppLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.app.builder.model.AppBuilderApp"}, service={AopService.class})
public class AppBuilderAppLocalServiceImpl
extends AppBuilderAppLocalServiceBaseImpl {
    @Reference
    private AppBuilderAppDeploymentLocalService _appBuilderAppDeploymentLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public AppBuilderApp addAppBuilderApp(long groupId, long companyId, long userId, long ddmStructureId, long ddmStructureLayoutId, long deDataListViewId, Map<Locale, String> nameMap, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        AppBuilderApp appBuilderApp = this.appBuilderAppPersistence.create(this.counterLocalService.increment());
        appBuilderApp.setGroupId(groupId);
        appBuilderApp.setCompanyId(companyId);
        appBuilderApp.setUserId(user.getUserId());
        appBuilderApp.setUserName(user.getFullName());
        appBuilderApp.setCreateDate(new Date());
        appBuilderApp.setModifiedDate(new Date());
        appBuilderApp.setDdmStructureId(ddmStructureId);
        appBuilderApp.setDdmStructureLayoutId(ddmStructureLayoutId);
        appBuilderApp.setDeDataListViewId(deDataListViewId);
        appBuilderApp.setNameMap(nameMap);
        appBuilderApp.setStatus(status);
        return (AppBuilderApp)this.appBuilderAppPersistence.update((BaseModel)appBuilderApp);
    }

    @Override
    public AppBuilderApp deleteAppBuilderApp(long appBuilderAppId) throws PortalException {
        List appBuilderAppDeployments = this._appBuilderAppDeploymentLocalService.getAppBuilderAppDeployments(appBuilderAppId);
        for (AppBuilderAppDeployment appBuilderAppDeployment : appBuilderAppDeployments) {
            this._appBuilderAppDeploymentLocalService.deleteAppBuilderAppDeployment(appBuilderAppDeployment.getAppBuilderAppDeploymentId());
        }
        return super.deleteAppBuilderApp(appBuilderAppId);
    }

    public void deleteAppBuilderApps(long ddmStructureId) throws PortalException {
        List<AppBuilderApp> appBuilderApps = this.getAppBuilderApps(ddmStructureId);
        for (AppBuilderApp appBuilderApp : appBuilderApps) {
            this.deleteAppBuilderApp(appBuilderApp.getAppBuilderAppId());
        }
    }

    public List<Long> getAppBuilderAppIds(int status, String type) {
        return this.appBuilderAppFinder.findByS_T(status, type);
    }

    public List<AppBuilderApp> getAppBuilderApps(long ddmStructureId) {
        return this.appBuilderAppPersistence.findByDDMStructureId(ddmStructureId);
    }

    public List<AppBuilderApp> getAppBuilderApps(long companyId, int status) {
        return this.appBuilderAppPersistence.findByC_S(companyId, status);
    }

    public List<AppBuilderApp> getAppBuilderApps(long groupId, int start, int end, OrderByComparator<AppBuilderApp> orderByComparator) {
        return this.appBuilderAppPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<AppBuilderApp> getAppBuilderApps(long groupId, long companyId, long ddmStructureId, int start, int end, OrderByComparator<AppBuilderApp> orderByComparator) {
        return this.appBuilderAppPersistence.findByG_C_D(groupId, companyId, ddmStructureId, start, end, orderByComparator);
    }

    public int getAppBuilderAppsCount(long groupId) {
        return this.appBuilderAppPersistence.countByGroupId(groupId);
    }

    public int getAppBuilderAppsCount(long groupId, long companyId, long ddmStructureId) {
        return this.appBuilderAppPersistence.countByG_C_D(groupId, companyId, ddmStructureId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AppBuilderApp updateAppBuilderApp(long userId, long appBuilderAppId, long ddmStructureId, long ddmStructureLayoutId, long deDataListViewId, Map<Locale, String> nameMap, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        AppBuilderApp appBuilderApp = this.appBuilderAppPersistence.findByPrimaryKey(appBuilderAppId);
        appBuilderApp.setUserId(user.getUserId());
        appBuilderApp.setUserName(user.getFullName());
        appBuilderApp.setModifiedDate(new Date());
        appBuilderApp.setDdmStructureId(ddmStructureId);
        appBuilderApp.setDdmStructureLayoutId(ddmStructureLayoutId);
        appBuilderApp.setDeDataListViewId(deDataListViewId);
        appBuilderApp.setNameMap(nameMap);
        appBuilderApp.setStatus(status);
        return (AppBuilderApp)this.appBuilderAppPersistence.update((BaseModel)appBuilderApp);
    }
}

