/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.internal.search.spi.model.index.contributor;

import com.liferay.app.builder.model.AppBuilderApp;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"indexer.class.name=com.liferay.app.builder.model.AppBuilderApp"}, service={ModelDocumentContributor.class})
public class AppBuilderAppModelDocumentContributor
implements ModelDocumentContributor<AppBuilderApp> {
    public void contribute(Document document, AppBuilderApp appBuilderApp) {
        String[] languageIds;
        document.addKeyword("ddmStructureId", appBuilderApp.getDdmStructureId());
        for (String languageId : languageIds = this.getLanguageIds(appBuilderApp.getDefaultLanguageId(), appBuilderApp.getName())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)languageId), appBuilderApp.getName(languageId));
        }
        document.addLocalizedKeyword("localized_name", LocalizationUtil.populateLocalizationMap((Map)appBuilderApp.getNameMap(), (String)appBuilderApp.getDefaultLanguageId(), (long)appBuilderApp.getGroupId()), true, true);
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

