/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.reports.rest.internal.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.liferay.analytics.reports.rest.dto.v1_0.AssetAppearsOnHistogramMetric;
import com.liferay.analytics.reports.rest.dto.v1_0.AssetDeviceMetric;
import com.liferay.analytics.reports.rest.dto.v1_0.AssetHistogramMetric;
import com.liferay.analytics.reports.rest.dto.v1_0.AssetMetric;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;

public class AnalyticsCloudClient {
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsCloudClient.class);
    private final Http _http;

    public AnalyticsCloudClient(Http http) {
        this._http = http;
    }

    public AssetAppearsOnHistogramMetric getAssetAppearsOnHistogramMetric(AnalyticsConfiguration analyticsConfiguration, String assetId, String assetType, List<Long> channelIds, String identityType, Integer rangeKey) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            options.setLocation(this._getUrl(assetId, assetType, channelIds, identityType, analyticsConfiguration.liferayAnalyticsFaroBackendURL(), "/appears-on/histogram", rangeKey));
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                AssetAppearsOnHistogramMetric assetAppearsOnHistogramMetric = null;
                JsonNode jsonNode = ObjectMapperHolder._objectMapper.readTree(content);
                if (jsonNode != null) {
                    TypeFactory typeFactory = TypeFactory.defaultInstance();
                    ObjectReader objectReader = ObjectMapperHolder._objectMapper.readerFor(typeFactory.constructType(AssetAppearsOnHistogramMetric.class));
                    assetAppearsOnHistogramMetric = (AssetAppearsOnHistogramMetric)objectReader.readValue(jsonNode);
                }
                return assetAppearsOnHistogramMetric;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to get asset histogram metric");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to get asset histogram metric", (Throwable)exception);
        }
    }

    public AssetDeviceMetric getAssetDeviceMetric(AnalyticsConfiguration analyticsConfiguration, String assetId, String assetType, List<Long> channelIds, String identityType, Integer rangeKey) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            options.setLocation(this._getUrl(assetId, assetType, channelIds, identityType, analyticsConfiguration.liferayAnalyticsFaroBackendURL(), "/devices", rangeKey));
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                AssetDeviceMetric assetDeviceMetric = null;
                JsonNode jsonNode = ObjectMapperHolder._objectMapper.readTree(content);
                if (jsonNode != null) {
                    TypeFactory typeFactory = TypeFactory.defaultInstance();
                    ObjectReader objectReader = ObjectMapperHolder._objectMapper.readerFor(typeFactory.constructType(AssetDeviceMetric.class));
                    assetDeviceMetric = (AssetDeviceMetric)objectReader.readValue(jsonNode);
                }
                return assetDeviceMetric;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to get asset histogram metric");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to get asset device metric", (Throwable)exception);
        }
    }

    public AssetHistogramMetric getAssetHistogramMetric(AnalyticsConfiguration analyticsConfiguration, String assetId, String assetType, List<Long> channelIds, String identityType, Integer rangeKey) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            options.setLocation(this._getUrl(assetId, assetType, channelIds, identityType, analyticsConfiguration.liferayAnalyticsFaroBackendURL(), "/histogram", rangeKey));
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                AssetHistogramMetric assetHistogramMetric = null;
                JsonNode jsonNode = ObjectMapperHolder._objectMapper.readTree(content);
                if (jsonNode != null) {
                    TypeFactory typeFactory = TypeFactory.defaultInstance();
                    ObjectReader objectReader = ObjectMapperHolder._objectMapper.readerFor(typeFactory.constructType(AssetHistogramMetric.class));
                    assetHistogramMetric = (AssetHistogramMetric)objectReader.readValue(jsonNode);
                }
                return assetHistogramMetric;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to get asset histogram metric");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to get asset histogram metric", (Throwable)exception);
        }
    }

    public AssetMetric getAssetMetric(AnalyticsConfiguration analyticsConfiguration, String assetId, String assetType, List<Long> channelIds, String identityType, Integer rangeKey, String[] selectedMetrics) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            String url = this._getUrl(assetId, assetType, channelIds, identityType, analyticsConfiguration.liferayAnalyticsFaroBackendURL(), "", rangeKey);
            url = HttpComponentsUtil.addParameter((String)url, (String)"selectedMetrics", (String)StringUtil.merge((Object[])selectedMetrics, (String)","));
            options.setLocation(url);
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                AssetMetric assetMetric = null;
                JsonNode jsonNode = ObjectMapperHolder._objectMapper.readTree(content);
                if (jsonNode != null) {
                    TypeFactory typeFactory = TypeFactory.defaultInstance();
                    ObjectReader objectReader = ObjectMapperHolder._objectMapper.readerFor(typeFactory.constructType(AssetMetric.class));
                    assetMetric = (AssetMetric)objectReader.readValue(jsonNode);
                }
                return assetMetric;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to get asset metric");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to get asset metric", (Throwable)exception);
        }
    }

    private Http.Options _getOptions(AnalyticsConfiguration analyticsConfiguration) throws Exception {
        Http.Options options = new Http.Options();
        options.addHeader("OSB-Asah-Faro-Backend-Security-Signature", analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature());
        options.addHeader("OSB-Asah-Project-ID", analyticsConfiguration.liferayAnalyticsProjectId());
        return options;
    }

    private String _getUrl(String assetId, String assetType, List<Long> channelIds, String identityType, String liferayAnalyticsFaroBackendURL, String path, Integer rangeKey) {
        String url = String.join((CharSequence)"", liferayAnalyticsFaroBackendURL, "/api/1.0/asset-metric/", assetType, path);
        url = HttpComponentsUtil.addParameter((String)url, (String)"assetId", (String)assetId);
        url = HttpComponentsUtil.addParameter((String)url, (String)"channelIds", (String)StringUtil.merge(channelIds, (String)","));
        url = HttpComponentsUtil.addParameter((String)url, (String)"identityType", (String)identityType);
        if (rangeKey != null) {
            url = HttpComponentsUtil.addParameter((String)url, (String)"rangeKey", (int)rangeKey);
        }
        return url;
    }

    private static class ObjectMapperHolder {
        private static final ObjectMapper _objectMapper = new ObjectMapper(){
            {
                this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            }
        };

        private ObjectMapperHolder() {
        }
    }
}

