/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.reports.rest.internal.resource.v1_0;

import com.liferay.analytics.reports.rest.dto.v1_0.AssetHistogramMetric;
import com.liferay.analytics.reports.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.reports.rest.internal.resource.v1_0.BaseAssetHistogramMetricResourceImpl;
import com.liferay.analytics.reports.rest.resource.v1_0.AssetHistogramMetricResource;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.util.AnalyticsSettingsManagerUtil;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/asset-histogram-metric.properties"}, scope=ServiceScope.PROTOTYPE, service={AssetHistogramMetricResource.class})
public class AssetHistogramMetricResourceImpl
extends BaseAssetHistogramMetricResourceImpl {
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;

    @Override
    public AssetHistogramMetric getGroupAssetMetricAssetTypeHistogram(Long groupId, String assetType, String assetId, String identityType, Integer rangeKey) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId.longValue());
        AnalyticsSettingsManagerUtil.checkSiteIdSynced((AnalyticsSettingsManager)this._analyticsSettingsManager, (Group)group);
        List<Object> analyticsCloudChannelIds = new ArrayList();
        DepotEntry depotEntry = this._depotEntryLocalService.fetchGroupDepotEntry(groupId.longValue());
        analyticsCloudChannelIds = depotEntry != null ? this.transform(this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(depotEntry), depotEntryGroupRel -> {
            Group depotEntryGroup = this._groupLocalService.getGroup(depotEntryGroupRel.getToGroupId());
            String analyticsChannelId = depotEntryGroup.getTypeSettingsProperty("analyticsChannelId");
            if (Validator.isNull((String)analyticsChannelId)) {
                return null;
            }
            return Long.valueOf(analyticsChannelId);
        }) : Collections.singletonList(Long.valueOf(group.getTypeSettingsProperty("analyticsChannelId")));
        AnalyticsCloudClient analyticsCloudClient = new AnalyticsCloudClient(this._http);
        return analyticsCloudClient.getAssetHistogramMetric(this._analyticsSettingsManager.getAnalyticsConfiguration(group.getCompanyId()), assetId, assetType, analyticsCloudChannelIds, identityType, rangeKey);
    }
}

